/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

public class Semaphore {
    private String name = null;
    private int permissions = 0;

    public Semaphore() {
        this(null, 0);
    }

    public Semaphore(int initialPermisions) {
        this(null, initialPermisions);
    }

    public Semaphore(String name, int initialPermissions) {
        this.name = name;
        this.permissions = initialPermissions;
    }

    public void acquire() {
        try {
            this.acquire(Long.MAX_VALUE);
        }
        catch (TimeOutException e) {
            e.printStackTrace();
        }
    }

    public synchronized void acquire(long timeout) throws TimeOutException {
        long start = System.currentTimeMillis();
        while (this.permissions <= 0 && timeout > 0L) {
            try {
                if (this.name != null) {
                    System.out.println(Thread.currentThread() + " - waiting to acquire: " + this.name);
                }
                if (timeout == Long.MAX_VALUE) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {}
            timeout -= System.currentTimeMillis() - start;
        }
        if (timeout <= 0L) {
            throw new TimeOutException();
        }
        --this.permissions;
        if (this.name != null) {
            System.out.println(Thread.currentThread() + " - acquired: " + this.name);
        }
    }

    public synchronized void release() {
        if (this.name != null) {
            System.out.println(Thread.currentThread() + " - releasing: " + this.name);
        }
        if (++this.permissions > 0) {
            this.notifyAll();
        }
    }

    public class TimeOutException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

