/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.list;

import org.eclipse.swt.graphics.Image;

public class CSSHtmlListStyleData {
    public static final int LIST_T_IMAGE = 0;
    public static final int LIST_T_DISC = 1;
    public static final int LIST_T_CIRCLE = 2;
    public static final int LIST_T_SQUARE = 3;
    public static final int LIST_T_DECIMAL = 17;
    public static final int LIST_T_DECIMAL_LEADING_ZERO = 18;
    public static final int LIST_T_LOWER_ALPHA = 19;
    public static final int LIST_T_LOWER_ROMAN = 20;
    public static final int LIST_T_UPPER_ALPHA = 21;
    public static final int LIST_T_UPPER_ROMAN = 22;
    private Image _markerImage;
    private int _type;

    public boolean isDefaultPicture() {
        return (this._type & 0xF) != 0;
    }

    private String getResolvedURL() {
        return "";
    }

    public Image getMarkerImage() {
        if (!this.isImage()) {
            return null;
        }
        if (this._markerImage == null) {
            String uri = this.getResolvedURL();
            this._markerImage = new Image(null, uri);
        }
        return this._markerImage;
    }

    public int getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = CSSHtmlListStyleData.toTypeInt(type);
    }

    public String getTextValue(int index) {
        if (!this.isText()) {
            return null;
        }
        return "";
    }

    public boolean isText() {
        return (this._type & 0xF0) != 0;
    }

    public boolean isImage() {
        return this._type == 0;
    }

    public static int toTypeInt(String type) {
        if (type.equalsIgnoreCase("decimal")) {
            return 17;
        }
        if (type.equalsIgnoreCase("decimal-leading-zero")) {
            return 18;
        }
        if (type.equalsIgnoreCase("disc")) {
            return 1;
        }
        if (type.equalsIgnoreCase("circle")) {
            return 2;
        }
        if (type.equalsIgnoreCase("square")) {
            return 3;
        }
        if (type.equalsIgnoreCase("image")) {
            return 0;
        }
        return 0;
    }
}

