/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.common.internal.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.xml.sax.EntityResolver;

public abstract class XMLResourceImpl
extends TranslatorResourceImpl
implements XMLResource,
J2EEVersionResource {
    protected boolean isAlt = false;
    protected Application application;
    protected boolean isNew = true;
    private Boolean needsSync = new Boolean(true);

    public XMLResourceImpl() {
    }

    public XMLResourceImpl(URI uri) {
        super(uri);
    }

    public XMLResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public XMLResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    protected void initializeContents() {
        super.initializeContents();
        this.eAdapters().add((Object)new RootVersionAdapter());
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public void setApplication(Application newApplication) {
        this.application = newApplication;
    }

    public void setIsAlt(boolean isAlternateDD) {
        this.isAlt = isAlternateDD;
    }

    protected int getDefaultVersionID() {
        return 14;
    }

    public void setDoctypeValues(String publicId, String systemId) {
        int version = 14;
        if (systemId == null) {
            version = 14;
        } else if (systemId.equals(this.getJ2EE_1_3_SystemID()) || systemId.equals(this.getJ2EE_Alt_1_3_SystemID())) {
            version = 13;
        } else if (systemId.equals(this.getJ2EE_1_2_SystemID()) || systemId.equals(this.getJ2EE_Alt_1_2_SystemID())) {
            version = 12;
        }
        super.setDoctypeValues(publicId, systemId);
        if (version != 14 || version == 14 && this.getModuleVersionID() == 0) {
            this.setJ2EEVersionID(version);
        }
    }

    public boolean usesDTD() {
        return this.getVersionID() == 12 || this.getVersionID() == 13;
    }

    public void setVersionID(int id) {
        this.setJ2EEVersionID(id);
    }

    protected void primSetVersionID(int id) {
        super.setVersionID(id);
    }

    protected void primSetDoctypeValues(String aPublicId, String aSystemId) {
        super.setDoctypeValues(aPublicId, aSystemId);
    }

    public abstract void setJ2EEVersionID(int var1);

    public abstract void setModuleVersionID(int var1);

    public boolean isJ2EE1_3() {
        return this.getVersionID() == 13;
    }

    public void setPublicId(String id) {
        this.setDoctypeValues(id, this.getSystemId());
    }

    public void setSystemId(String id) {
        this.setDoctypeValues(this.getPublicId(), id);
    }

    protected String getDefaultPublicId() {
        switch (this.getVersionID()) {
            case 12: {
                return this.getJ2EE_1_2_PublicID();
            }
            case 13: {
                return this.getJ2EE_1_3_PublicID();
            }
        }
        return null;
    }

    protected String getDefaultSystemId() {
        switch (this.getVersionID()) {
            case 12: {
                return this.getJ2EE_1_2_SystemID();
            }
            case 13: {
                return this.getJ2EE_1_3_SystemID();
            }
        }
        return null;
    }

    public abstract String getJ2EE_1_2_PublicID();

    public abstract String getJ2EE_1_2_SystemID();

    public String getJ2EE_Alt_1_2_SystemID() {
        return this.getJ2EE_1_2_SystemID();
    }

    public abstract String getJ2EE_1_3_PublicID();

    public abstract String getJ2EE_1_3_SystemID();

    public String getJ2EE_Alt_1_3_SystemID() {
        return this.getJ2EE_1_3_SystemID();
    }

    public NotificationChain basicSetResourceSet(ResourceSet aResourceSet, NotificationChain notifications) {
        if (aResourceSet == null && this.resourceSet != null) {
            this.preDelete();
        }
        return super.basicSetResourceSet(aResourceSet, notifications);
    }

    public Application getApplication() {
        return this.application;
    }

    public int getVersionID() {
        return this.getJ2EEVersionID();
    }

    public EntityResolver getEntityResolver() {
        return J2EEXmlDtDEntityResolver.INSTANCE;
    }

    public abstract int getJ2EEVersionID();

    public int getModuleVersionID() {
        return super.getVersionID();
    }

    protected abstract void syncVersionOfRootObject();

    protected String getModuleVersionString() {
        int ver = this.getModuleVersionID();
        return new BigDecimal(String.valueOf(ver)).movePointLeft(1).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExisting(Map options) throws IOException {
        boolean localNeedsSync = false;
        Boolean bl = this.needsSync;
        synchronized (bl) {
            localNeedsSync = this.needsSync;
        }
        if (localNeedsSync) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this);
            if (!file.isSynchronized(0)) {
                try {
                    Workspace workspace = (Workspace)file.getWorkspace();
                    if (workspace.getElementTree().isImmutable()) {
                        workspace.newWorkingTree();
                    }
                    ((Resource)file).getLocalManager().refresh((IResource)file.getProject(), 2, true, null);
                }
                catch (CoreException e) {
                    throw new Resource.IOWrappedException((Exception)((Object)e));
                }
            }
            Boolean bl2 = this.needsSync;
            synchronized (bl2) {
                this.needsSync = new Boolean(false);
            }
        }
        super.loadExisting(options);
    }

    private static class RootVersionAdapter
    extends AdapterImpl {
        private RootVersionAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return super.isAdapterForType(type);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(null) == 2 && msg.getEventType() == 3) {
                ((XMLResourceImpl)msg.getNotifier()).syncVersionOfRootObject();
                ((Notifier)msg.getNotifier()).eAdapters().remove((Object)this);
            }
        }
    }
}

