/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITagConverterContext;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTransformOperation
implements ITransformOperation {
    protected ITagConverterContext tagConverterContext;
    protected List childOperations;
    private String[] params;
    private String id = "<not set>";

    void setParameters(String[] params) {
        if (params != null) {
            this.params = new String[params.length];
            System.arraycopy(params, 0, this.params, 0, params.length);
        }
    }

    protected String[] getParameters() {
        return this.params;
    }

    void setTransformOperationID(String id) {
        this.id = id;
    }

    protected String getTransformOperationID() {
        return this.id;
    }

    protected Logger getLog() {
        return PDPlugin.getLogger(TransformOperationFactory.class);
    }

    @Override
    public abstract Element transform(Element var1, Element var2);

    @Override
    public void setTagConverterContext(ITagConverterContext tagConverterContext) {
        this.tagConverterContext = tagConverterContext;
    }

    @Override
    public void appendChildOperation(ITransformOperation operation) {
        if (operation != null) {
            if (this.childOperations == null) {
                this.childOperations = new ArrayList();
            }
            operation.setTagConverterContext(this.tagConverterContext);
            this.childOperations.add(operation);
        }
    }

    @Override
    public List getChildOperations() {
        return this.childOperations;
    }

    protected Element executeChildOperations(Element srcElement, Element curElement) {
        Element retElement = curElement;
        if (this.childOperations != null && this.childOperations.size() > 0) {
            for (ITransformOperation childOperation : this.childOperations) {
                retElement = childOperation.transform(srcElement, retElement);
            }
        }
        return retElement;
    }

    protected Element createElement(String tagName) {
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CreateElementOperation, new String[]{tagName});
        operation.setTagConverterContext(this.tagConverterContext);
        return operation.transform(null, null);
    }

    protected Element appendChildElement(String tagName, Element parentElement) {
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_AppendChildElementOperation, new String[]{tagName});
        operation.setTagConverterContext(this.tagConverterContext);
        return operation.transform(null, parentElement);
    }

    protected void appendChildText(String content, Element parentElement) {
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_AppendChildTextOperation, new String[]{content});
        operation.setTagConverterContext(this.tagConverterContext);
        operation.transform(null, parentElement);
    }

    protected List getChildElements(Node srcNode, String tagName) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        NodeList childNodes = srcNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            String curNodeName;
            Node curNode = childNodes.item(i);
            if (curNode.getNodeType() == 1 && (curNodeName = curNode.getLocalName()) != null && curNodeName.equals(tagName)) {
                childElements.add(curNode);
            }
            ++i;
        }
        return childElements;
    }
}

