/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal.facets;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;

public final class FacetUtil {
    private FacetUtil() {
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IRuntime[] runtimes;
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime r = iRuntimeArray[n2];
            if (id.equals(r.getId())) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static org.eclipse.wst.common.project.facet.core.runtime.IRuntime getRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getId();
        if (id == null) {
            return null;
        }
        Set runtimes = RuntimeManager.getRuntimes();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 : runtimes) {
            if (!id.equals(runtime2.getProperty("id"))) continue;
            return runtime2;
        }
        return null;
    }

    public static final IStatus verifyFacets(IProject project, IServer server) {
        if (server == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorNoRuntime, null);
        }
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorNoRuntime, null);
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 = FacetUtil.getRuntime(runtime);
        if (runtime2 == null) {
            return Status.OK_STATUS;
        }
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                if (runtime2.supports(facet)) continue;
                return new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorFacet, (Object)facet.getProjectFacet().getLabel(), (Object)facet.getVersionString()), null);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRuntimeTargeted(IRuntime runtime) {
        try {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 = FacetUtil.getRuntime(runtime);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (projects == null) return false;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (true) {
                Set set;
                if (n2 >= n) {
                    return false;
                }
                IProject project = iProjectArray[n2];
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && (set = facetedProject.getTargetedRuntimes()) != null && set.contains(runtime2)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            if (!Trace.WARNING) return false;
            Trace.trace("/warning", "Could not determine if runtime is in use", t);
        }
        return false;
    }

    public static void removeTargets(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        block6: {
            try {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime2 = FacetUtil.getRuntime(runtime);
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (projects != null) {
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Set set;
                        IProject project = iProjectArray[n2];
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                        if (facetedProject != null && (set = facetedProject.getTargetedRuntimes()) != null && set.contains(runtime2)) {
                            facetedProject.removeTargetedRuntime(runtime2, monitor);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException ce) {
                throw ce;
            }
            catch (Throwable t) {
                if (!Trace.WARNING) break block6;
                Trace.trace("/warning", "Could not remove runtime target", t);
            }
        }
    }
}

