/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.core.uri;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public abstract class NativeFileCommand
extends AbstractDataModelOperation {
    protected String name;
    protected String description;
    protected IURI[] urisToRead;
    protected IURI[] urisToWrite;

    protected NativeFileCommand() {
        this(null, null);
    }

    protected NativeFileCommand(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setURIsToRead(IURI[] urisToRead) {
        this.urisToRead = urisToRead;
    }

    public IURI[] getURIsToRead() {
        return this.urisToRead;
    }

    public void setURIsToWrite(IURI[] urisToWrite) {
        this.urisToWrite = urisToWrite;
    }

    public IURI[] getURIsToWrite() {
        return this.urisToWrite;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        File[] filesToRead = this.getFiles(this.urisToRead);
        File[] filesToWrite = this.getFiles(this.urisToWrite);
        this.preProcess(filesToRead, filesToWrite);
        IStatus status = this.execute(filesToRead, filesToWrite);
        this.postProcess(filesToRead, filesToWrite);
        return status;
    }

    public abstract IStatus execute(File[] var1, File[] var2);

    private void preProcess(File[] filesToRead, File[] filesToWrite) {
    }

    private void postProcess(File[] filesToRead, File[] filesToWrite) {
    }

    private File[] getFiles(IURI[] uris) {
        LinkedList<File> list = new LinkedList<File>();
        if (uris != null) {
            int i = 0;
            while (i < uris.length) {
                if (uris[i].isAvailableAsFile()) {
                    try {
                        list.add(uris[i].asFile());
                    }
                    catch (URIException uRIException) {}
                }
                ++i;
            }
        }
        return list.toArray(new File[0]);
    }
}

