/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.facelet;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.core.internal.IJSFPreferenceModel;
import org.eclipse.jst.jsf.validation.internal.Severity;

public class FaceletValidationPreferences
implements IJSFPreferenceModel {
    private int[] _severities;
    public static final String CANNOT_FIND_FACELET_TAGLIB = FaceletValidationPreferences.createQualifiedKeyName("CANNOT_FIND_FACELET_TAGLIB");

    @Override
    public void load(IPreferenceStore prefStore) {
        this.loadSeverities(prefStore);
    }

    private void loadSeverities(IPreferenceStore prefStore) {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < 1) {
            String key = FaceletValidationPreferences.getKeyById(i);
            if (!prefStore.contains(key)) {
                int diagSeverity = FaceletValidationPreferences.getDefaultSeverity(i);
                Severity severity = FaceletValidationPreferences.mapDiagToSeverity(diagSeverity);
                prefStore.setDefault(key, severity.toString());
            }
            String storedSeverity = prefStore.getString(key);
            severities[i] = FaceletValidationPreferences.mapSeverityToDiag(storedSeverity);
            ++i;
        }
    }

    @Override
    public void commit(IPreferenceStore prefStore) {
        this.commitSeverities(prefStore);
    }

    private void commitSeverities(IPreferenceStore prefStore) {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < severities.length) {
            String key = FaceletValidationPreferences.getKeyById(i);
            prefStore.setValue(key, FaceletValidationPreferences.mapDiagToSeverity(severities[i]).toString());
            ++i;
        }
    }

    @Override
    public void setDefaults() {
        this.setProblemSeverityDefaults();
    }

    private void setProblemSeverityDefaults() {
        int[] severities = this.getSeverities();
        int i = 0;
        while (i < 30) {
            severities[i] = FaceletValidationPreferences.getDefaultSeverity(i);
            ++i;
        }
    }

    @Override
    public Object getValueByKey(IScopeContext context, String key) {
        try {
            Severity severity = this.getSeverity(key);
            return severity.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public Object getStoredValueByKey(IScopeContext context, String key) {
        try {
            return context.getNode("org.eclipse.jst.jsf.core").get(key, FaceletValidationPreferences.mapDiagToSeverity(FaceletValidationPreferences.getDefaultSeverity(FaceletValidationPreferences.getIdByKey(key))).toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public Object setValueByKey(IScopeContext context, String key, Object value) {
        Severity oldValue = this.getSeverity(key);
        this.setSeverity(key, (Severity)((Object)value));
        return oldValue;
    }

    public Severity getSeverity(String key) {
        int severityDiag = this._severities[FaceletValidationPreferences.getIdByKey(key)];
        Severity severity = FaceletValidationPreferences.mapDiagToSeverity(severityDiag);
        return severity;
    }

    public void setSeverity(String key, Severity severity) {
        int newSeverityDiag = FaceletValidationPreferences.mapSeverityToDiag(severity.toString());
        int diagId = FaceletValidationPreferences.getIdByKey(key);
        this._severities[diagId] = newSeverityDiag;
    }

    public final int getDiagnosticSeverity(int diagnosticId) {
        return this.getSeverities()[diagnosticId];
    }

    private int[] getSeverities() {
        if (this._severities == null) {
            this._severities = new int[1];
        }
        return this._severities;
    }

    public static Severity mapDiagToSeverity(int diagSeverity) {
        switch (diagSeverity) {
            case 4: {
                return Severity.ERROR;
            }
            case 2: {
                return Severity.WARNING;
            }
        }
        return Severity.IGNORE;
    }

    public static int mapSeverityToDiag(String severity) {
        if ("error".equals(severity)) {
            return 4;
        }
        if ("warning".equals(severity)) {
            return 2;
        }
        if ("ignore".equals(severity)) {
            return 0;
        }
        throw new IllegalArgumentException("Invalid enum name: " + severity);
    }

    public static int getDefaultSeverity(int diagnosticId) {
        switch (diagnosticId) {
            case 0: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Diagnostic Id: " + diagnosticId + " is out of range");
    }

    public static String getKeyById(int diagnosticId) {
        switch (diagnosticId) {
            case 0: {
                return CANNOT_FIND_FACELET_TAGLIB;
            }
        }
        throw new IllegalArgumentException("Diagnostic Id: " + diagnosticId + " is out of range");
    }

    public static int getIdByKey(String key) {
        if (CANNOT_FIND_FACELET_TAGLIB.equals(key)) {
            return 0;
        }
        throw new IllegalArgumentException("Severity Key: " + key);
    }

    private static String createQualifiedKeyName(String baseName) {
        return "org.eclipse.jst.jsf.core." + baseName;
    }
}

