/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.IMultiElementTreeContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.ScriptExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class WorkingSetAwareContentProvider
extends ScriptExplorerContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;

    public WorkingSetAwareContentProvider(boolean provideMembers, WorkingSetModel model) {
        super(provideMembers);
        this.fWorkingSetModel = model;
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetAwareContentProvider.this.workingSetModelChanged(event);
            }
        };
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    @Override
    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object element) {
        if (element instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == element ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        Object[] children = element instanceof IWorkingSet ? this.getWorkingSetChildren((IWorkingSet)element) : super.getChildren(element);
        return children;
    }

    private Object[] getWorkingSetChildren(IWorkingSet set) {
        IAdaptable[] elements = this.fWorkingSetModel.getChildren(set);
        HashSet<Object> result = new HashSet<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IProject project;
            IAdaptable element = elements[i];
            if (element instanceof IProject) {
                this.processResource((IResource)((IProject)element), result);
                result.add(element);
            } else if (element instanceof IResource) {
                project = ((IResource)element).getProject();
                if (project.isOpen()) {
                    result.add(element);
                }
            } else if (element instanceof IJavaScriptProject) {
                result.add(((IJavaScriptProject)element).getProject());
            } else if (element instanceof IJavaScriptElement) {
                IJavaScriptElement elem = (IJavaScriptElement)element;
                IProject project2 = this.getProject(elem);
                if (project2 != null && project2.isOpen()) {
                    result.add(elem);
                }
            } else {
                project = (IProject)element.getAdapter(IProject.class);
                if (project != null) {
                    this.processResource((IResource)project, result);
                }
            }
            ++i;
        }
        return result.toArray();
    }

    private void processResource(IResource resource, Collection result) {
        IJavaScriptElement elem = JavaScriptCore.create((IResource)resource);
        if (elem != null && elem.exists()) {
            result.add(elem);
        } else {
            result.add(resource);
        }
    }

    private IProject getProject(IJavaScriptElement element) {
        IJavaScriptProject project = element.getJavaScriptProject();
        if (project == null) {
            return null;
        }
        return project.getProject();
    }

    @Override
    public TreePath[] getTreePaths(Object element) {
        if (element instanceof IWorkingSet) {
            TreePath path = new TreePath(new Object[]{element});
            return new TreePath[]{path};
        }
        List modelParents = this.getModelPath(element);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < modelParents.size()) {
            result.addAll(this.getTreePaths(modelParents, i));
            ++i;
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List getModelPath(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(element);
        Object parent = super.getParent(element);
        Object input = this.getViewerInput();
        while (parent != null && !parent.equals(input) && !(parent instanceof IJavaScriptModel)) {
            result.add(parent);
            parent = super.getParent(parent);
        }
        Collections.reverse(result);
        return result;
    }

    private List getTreePaths(List modelParents, int index) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object input = this.getViewerInput();
        Object element = modelParents.get(index);
        Object[] parents = this.fWorkingSetModel.getAllParents(element);
        int i = 0;
        while (i < parents.length) {
            ArrayList<Object> chain = new ArrayList<Object>();
            if (!parents[i].equals(input)) {
                chain.add(parents[i]);
            }
            int m = index;
            while (m < modelParents.size()) {
                chain.add(modelParents.get(m));
                ++m;
            }
            result.add(new TreePath(chain.toArray()));
            ++i;
        }
        return result;
    }

    @Override
    public Object getParent(Object child) {
        Object[] parents = this.fWorkingSetModel.getAllParents(child);
        if (parents.length == 0) {
            return super.getParent(child);
        }
        Object first = parents[0];
        return first;
    }

    @Override
    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
        Object parent;
        if (JavaScriptCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(affectedElement)) {
            toRefresh.remove(affectedElement);
            toRefresh.add(this.fWorkingSetModel);
        } else if (relation == 2 && (parent = this.internalGetParent(affectedElement)) != null) {
            toRefresh.addAll(Arrays.asList(this.fWorkingSetModel.getAllParents(parent)));
        }
        List nonProjetTopLevelElemens = this.fWorkingSetModel.getNonProjectTopLevelElements();
        if (nonProjetTopLevelElemens.isEmpty()) {
            return;
        }
        ArrayList toAdd = new ArrayList();
        for (Object element : nonProjetTopLevelElemens) {
            if (!this.isChildOf(element, toRefresh)) continue;
            toAdd.add(element);
        }
        toRefresh.addAll(toAdd);
    }

    private void workingSetModelChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(property)) {
            toRefresh.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(property)) {
            toRefresh.add(newValue);
        } else if ("workingSetNameChange".equals(property)) {
            toRefresh.add(newValue);
        }
        ArrayList runnables = new ArrayList();
        this.postRefresh(toRefresh, true, runnables);
        this.executeRunnables(runnables);
    }

    private boolean isChildOf(Object element, List potentialParents) {
        Object parent = super.getParent(element);
        if (parent == null) {
            return false;
        }
        for (Object potentialParent : potentialParents) {
            while (parent != null) {
                if (parent.equals(potentialParent)) {
                    return true;
                }
                parent = super.getParent(parent);
            }
        }
        return false;
    }
}

