/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsDefaultsCalculator {
    private static final String ARG = "arg";
    private static final String RETURN = "return";
    private static final String RESPONSE = "Response";

    public SOAPBindingStyle defineSBStyle(IAnnotation<? extends IJavaElement> sbAnnotation) {
        String value;
        String string = value = sbAnnotation != null ? sbAnnotation.getPropertyValue("style") : null;
        if (value != null && "javax.jws.soap.SOAPBinding.SOAPBinding.Style.RPC".endsWith(value.trim())) {
            return SOAPBindingStyle.RPC;
        }
        return SOAPBindingStyle.DOCUMENT;
    }

    public SOAPBindingUse defineSBUse(IAnnotation<? extends IJavaElement> sbAnnotation) {
        String value;
        String string = value = sbAnnotation != null ? sbAnnotation.getPropertyValue("use") : null;
        if (value != null && "javax.jws.soap.SOAPBinding.Use.ENCODED".endsWith(value.trim())) {
            return SOAPBindingUse.ENCODED;
        }
        return SOAPBindingUse.LITERAL;
    }

    public SOAPBindingParameterStyle defineSBParameterStyle(IAnnotation<? extends IJavaElement> sbAnnotation) {
        String value;
        String string = value = sbAnnotation != null ? sbAnnotation.getPropertyValue("parameterStyle") : null;
        if (value != null && "javax.jws.soap.SOAPBinding.ParameterStyle.BARE".endsWith(value.trim())) {
            return SOAPBindingParameterStyle.BARE;
        }
        return SOAPBindingParameterStyle.WRAPPED;
    }

    public String calcWebParamDefaultName(IWebMethod webMethod, int paramPosition) {
        if (webMethod.getSoapBindingStyle() == SOAPBindingStyle.DOCUMENT && webMethod.getSoapBindingParameterStyle() == SOAPBindingParameterStyle.BARE) {
            return webMethod.getName();
        }
        return ARG + paramPosition;
    }

    public String calcWebParamDefaultName(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        return this.calcWebParamDefaultName(webMethod, this.getParamPosition(webMethod, webParam));
    }

    protected int getParamPosition(IWebMethod webMethod, IWebParam param) {
        int position = 0;
        for (IWebParam webParam : webMethod.getParameters()) {
            if (webParam.getImplementation().equals(RETURN)) continue;
            if (webParam == param) {
                return position;
            }
            ++position;
        }
        throw new IllegalStateException("Parameter[" + param.getImplementation() + "] was not found in method [" + webMethod.getImplementation() + "]");
    }

    public String calcWebParamDefaultTargetNS(IWebMethod webMethod, IWebParam webParam) {
        if (webMethod.getSoapBindingStyle() == SOAPBindingStyle.DOCUMENT && webMethod.getSoapBindingParameterStyle() == SOAPBindingParameterStyle.WRAPPED && !webParam.isHeader()) {
            return "";
        }
        return ((IServiceEndpointInterface)webMethod.eContainer()).getTargetNamespace();
    }

    public WebParamKind getDefaultParamKind() {
        return WebParamKind.IN;
    }

    public boolean getDefaultParamInHedaer() {
        return false;
    }

    public String calcWebResultDefaultName(IWebMethod webMethod) {
        if (webMethod.getSoapBindingStyle() == SOAPBindingStyle.DOCUMENT && webMethod.getSoapBindingParameterStyle() == SOAPBindingParameterStyle.BARE) {
            return String.valueOf(webMethod.getName()) + RESPONSE;
        }
        return RETURN;
    }
}

