/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist.resources;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.contentassist.resources.AbstractWebResourcesCompletionProposalComputer;
import org.eclipse.wst.html.ui.internal.contentassist.resources.ContentTypeSpecs;
import org.eclipse.wst.html.ui.internal.contentassist.resources.ImageCompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Node;

public class ImageWebResourcesCompletionProposalComputer
extends AbstractWebResourcesCompletionProposalComputer {
    ContentTypeSpecs fileMatcher = ContentTypeSpecs.createFor("org.eclipse.ui.content-type.images");

    @Override
    protected ICompletionProposal createCompletionProposal(ContentAssistRequest request, IPath referencePath, IPath runtimeReferencePath, IPath proposalPath, IPath runtimeProposalPath, String relativeProposal) {
        String replacementString = String.valueOf('\"') + relativeProposal + '\"';
        int cursorPosition = replacementString.length();
        Image image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(proposalPath.lastSegment()).createImage();
        if (image != null) {
            this.images.add(image);
        }
        int replacementLength = request.getRegion().getTextLength();
        int replacementOffset = request.getStartOffset();
        URL previewURL = null;
        String previewErrorInfo = null;
        try {
            previewURL = new URL("platform://resource" + proposalPath);
        }
        catch (Exception ex) {
            previewErrorInfo = NLS.bind((String)HTMLUIMessages.cannotGenerateImagePreview, (Object)ex.getMessage());
        }
        if (previewURL != null) {
            return new ImageCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, relativeProposal, previewURL, 0);
        }
        return new CustomCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, relativeProposal, null, previewErrorInfo, 0);
    }

    @Override
    ContentTypeSpecs createFilenameMatcher() {
        return this.fileMatcher;
    }

    @Override
    boolean matchRequest(ContentAssistRequest contentAssistRequest) {
        Node node = contentAssistRequest.getNode();
        return "img".equals(node.getLocalName()) && "src".equals(this.getCurrentAttributeName(contentAssistRequest));
    }
}

