/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolutionResult;
import org.eclipse.wst.wsdl.validation.internal.util.LazyURLInputStream;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalog;

public class URIResolver
implements IExtensibleURIResolver,
XMLEntityResolver {
    private List extURIResolversList = new ArrayList();

    public void addURIResolver(IExtensibleURIResolver uriResolver) {
        this.extURIResolversList.add(uriResolver);
    }

    @Override
    public void resolve(String baseLocation, String publicId, String systemId, IURIResolutionResult result) {
        String tempresult;
        for (IExtensibleURIResolver resolver : this.extURIResolversList) {
            if (resolver == null) continue;
            resolver.resolve(baseLocation, publicId, systemId, result);
            if (result.getLogicalLocation() != null && !result.getPhysicalLocation().equals(systemId)) break;
        }
        if (result.getLogicalLocation() == null && (publicId != null || systemId != null) && (tempresult = XMLCatalog.getInstance().resolveEntityLocation(publicId, systemId)) != null) {
            result.setLogicalLocation(tempresult);
            result.setPhysicalLocation(tempresult);
        }
        if (result.getLogicalLocation() == null) {
            result.setLogicalLocation(this.normalize(baseLocation, systemId));
            result.setPhysicalLocation(result.getLogicalLocation());
        }
    }

    public IURIResolutionResult resolve(String baseLocation, String publicId, String systemId) {
        URIResolutionResult result = new URIResolutionResult();
        this.resolve(baseLocation, publicId, systemId, result);
        return result;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String publicId = resourceIdentifier.getPublicId();
        String systemId = resourceIdentifier.getLiteralSystemId();
        if (publicId == null || publicId.equals("")) {
            publicId = resourceIdentifier.getNamespace();
        }
        IURIResolutionResult result = this.resolve(resourceIdentifier.getBaseSystemId(), publicId, systemId);
        XMLInputSource xmlInputSource = null;
        if (result != null) {
            LazyURLInputStream is = new LazyURLInputStream(result.getPhysicalLocation());
            xmlInputSource = new XMLInputSource(publicId, result.getLogicalLocation(), result.getLogicalLocation(), (InputStream)is, null);
        }
        return xmlInputSource;
    }

    protected String normalize(String baseLocation, String systemId) {
        int loc;
        if (systemId == null) {
            return systemId;
        }
        int schemaLoc = systemId.indexOf(58);
        if (schemaLoc != -1 && systemId.charAt(schemaLoc + 1) == '/') {
            return systemId;
        }
        if (baseLocation == null) {
            return baseLocation;
        }
        String result = "";
        baseLocation = baseLocation.replace('\\', '/');
        systemId = systemId.replace('\\', '/');
        int lastSlash = baseLocation.lastIndexOf(47);
        String tempresult = baseLocation.substring(0, lastSlash + 1);
        if (systemId.startsWith("/")) {
            systemId = systemId.substring(1);
        }
        tempresult = String.valueOf(tempresult) + systemId;
        block0: while ((loc = tempresult.lastIndexOf("./")) != -1) {
            int loc2;
            String temp;
            result = String.valueOf(tempresult.substring(loc + 2)) + result;
            if (tempresult.charAt(loc - 1) == '.') {
                if (tempresult.charAt(loc - 2) == '/') {
                    temp = tempresult.substring(0, loc - 2);
                    loc2 = temp.lastIndexOf(47);
                    if (loc2 == -1) {
                        result = "../" + result;
                        tempresult = tempresult.substring(0, loc - 1);
                        continue;
                    }
                    tempresult = tempresult.substring(0, loc - 1);
                    int numSectsToRemove = 1;
                    while (tempresult.endsWith("./")) {
                        int tempreslen = tempresult.length();
                        if (tempreslen > 2 && tempresult.charAt(tempreslen - 3) == '.') {
                            if (tempreslen <= 3 || tempresult.charAt(tempreslen - 4) != '/') break;
                            ++numSectsToRemove;
                            tempresult = tempresult.substring(0, tempresult.length() - 3);
                            continue;
                        }
                        if (tempresult.charAt(tempresult.length() - 2) != '/') break;
                        tempresult = tempresult.substring(0, tempresult.length() - 2);
                    }
                    int i = 0;
                    while (i < numSectsToRemove) {
                        String temp2 = tempresult.substring(0, tempresult.length() - 1);
                        int loc3 = temp2.lastIndexOf(47);
                        if (loc3 == -1) continue block0;
                        tempresult = tempresult.substring(0, loc3 + 1);
                        ++i;
                    }
                    continue;
                }
                temp = tempresult.substring(0, loc - 1);
                loc2 = temp.lastIndexOf(47);
                if (loc2 == -1) {
                    result = String.valueOf(tempresult.substring(0, loc + 2)) + result;
                    tempresult = "";
                    continue;
                }
                result = tempresult.substring(loc2 + 1, tempresult.length());
                tempresult = tempresult.substring(0, loc2 + 1);
                continue;
            }
            if (tempresult.charAt(loc - 1) == '/') {
                tempresult = tempresult.substring(0, loc);
                continue;
            }
            temp = tempresult.substring(0, loc - 1);
            loc2 = temp.lastIndexOf(47);
            if (loc2 == -1) {
                result = String.valueOf(tempresult.substring(0, loc)) + result;
                tempresult = "";
                continue;
            }
            result = tempresult.substring(loc2 + 1, tempresult.length());
            tempresult = tempresult.substring(0, loc2 + 1);
        }
        result = String.valueOf(tempresult) + result;
        return result;
    }
}

