/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.snippets.core.ISnippetProvider;
import org.eclipse.wst.common.snippets.internal.SnippetContributor;
import org.eclipse.wst.common.snippets.ui.TextSnippetProvider;

public class SnippetProviderManager {
    private static ISnippetProvider[] getProviders() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.common.snippets.SnippetProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<ISnippetProvider> providerList = new ArrayList<ISnippetProvider>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                SnippetContributor sc = new SnippetContributor(configurationElements[j]);
                if (sc.getProvider() != null) {
                    providerList.add(sc.getProvider());
                }
                ++j;
            }
            ++i;
        }
        return providerList.toArray(new ISnippetProvider[providerList.size()]);
    }

    public static ISnippetProvider findProvider(String id) {
        Assert.isNotNull((Object)id);
        ISnippetProvider[] providers = SnippetProviderManager.getProviders();
        int i = 0;
        while (i < providers.length) {
            if (id.equals(providers[i].getId())) {
                return providers[i];
            }
            ++i;
        }
        return new TextSnippetProvider();
    }

    public static ISnippetProvider getApplicableProvider(IEditorPart targetEditor) {
        SnippetContributor applicableContributor = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.common.snippets.SnippetProvider");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    SnippetContributor sc = new SnippetContributor(configurationElements[j]);
                    if (sc.isApplicable(targetEditor) && (applicableContributor == null || applicableContributor.getPriority() > sc.getPriority())) {
                        applicableContributor = sc;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (applicableContributor == null) {
            return null;
        }
        ISnippetProvider provider = applicableContributor.getProvider();
        if (provider != null) {
            provider.setEditor(targetEditor);
        }
        return provider;
    }
}

