/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.ISOAPEncodingWrapperFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDDelegationFragment;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPEncodingWrapperFragment
extends XSDDelegationFragment
implements ISOAPEncodingWrapperFragment {
    private static final String ID = "id";
    private static final String HREF = "href";
    private static final String POUND = "#";
    private Hashtable uriReferenceTable_ = null;

    public SOAPEncodingWrapperFragment(String id, String name, XSDToFragmentConfiguration config) {
        super(id, name, null);
    }

    @Override
    public void setXSDToFragmentConfiguration(XSDToFragmentConfiguration config) {
        this.getXSDDelegationFragment().setXSDToFragmentConfiguration(config);
    }

    @Override
    public XSDToFragmentConfiguration getXSDToFragmentConfiguration() {
        return this.getXSDDelegationFragment().getXSDToFragmentConfiguration();
    }

    @Override
    public void setXSDTypeDefinition(XSDTypeDefinition typeDef) {
        this.getXSDDelegationFragment().setXSDTypeDefinition(typeDef);
    }

    @Override
    public XSDTypeDefinition getXSDTypeDefinition() {
        return this.getXSDDelegationFragment().getXSDTypeDefinition();
    }

    @Override
    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        int i = 0;
        while (i < instanceDocuments.length) {
            instanceDocuments[i] = SOAPEncodingWrapperFragment.resolveURIReferences(this.uriReferenceTable_, instanceDocuments[i]);
            ++i;
        }
        return this.getXSDDelegationFragment().setParameterValuesFromInstanceDocuments(instanceDocuments);
    }

    @Override
    public void setURIReferences(Hashtable uriReferences) {
        this.uriReferenceTable_ = uriReferences;
    }

    public static Hashtable parseURIReferences(Element element, boolean overwrites) {
        Hashtable uriReferences = new Hashtable();
        SOAPEncodingWrapperFragment.parseURIReferences(uriReferences, element, overwrites);
        return uriReferences;
    }

    private static boolean parseURIReferences(Hashtable uriReferences, Element element, boolean overwrites) {
        boolean resolved = true;
        if (element != null) {
            URIReference ref = null;
            String id = element.getAttribute(ID);
            boolean bl = resolved = !element.hasAttribute(HREF);
            if (id != null && id.length() > 0 && (overwrites || !uriReferences.contains(id))) {
                ref = new URIReference(element, true);
                uriReferences.put(id, ref);
            }
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node instanceof Element) {
                    resolved = SOAPEncodingWrapperFragment.parseURIReferences(uriReferences, (Element)node, overwrites) && resolved;
                }
                ++i;
            }
            if (ref != null) {
                ref.setResolved(resolved);
            }
        }
        return resolved;
    }

    public static Element resolveURIReferences(Hashtable uriReferences, Element element) {
        if (uriReferences != null && !uriReferences.isEmpty()) {
            return SOAPEncodingWrapperFragment.resolveURIReferences(uriReferences, element.getOwnerDocument(), element, new Vector());
        }
        return element;
    }

    private static Element resolveURIReferences(Hashtable uriReferences, Document doc, Element element, Vector usedIds) {
        String href = element.getAttribute(HREF);
        Element resolvedElement = element;
        boolean resolved = false;
        if (href != null && href.length() > 0) {
            URIReference ref = null;
            if (href.indexOf(POUND) != -1) {
                href = href.substring(1, href.length());
            }
            if (!usedIds.contains(href) && (ref = (URIReference)uriReferences.get(href)) != null) {
                usedIds.add(href);
                Element elementRef = ref.getRefElement();
                resolved = ref.getResolved();
                resolvedElement = doc.createElement(element.getTagName());
                NodeList nl = elementRef.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node node = nl.item(i);
                    if (node != null) {
                        resolvedElement.appendChild(doc.importNode(node, true));
                    }
                    ++i;
                }
            }
        }
        if (!resolved) {
            NodeList nl = resolvedElement.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Element child;
                Node node = nl.item(i);
                if (node instanceof Element && (child = SOAPEncodingWrapperFragment.resolveURIReferences(uriReferences, resolvedElement.getOwnerDocument(), (Element)node, usedIds)) != node) {
                    resolvedElement.replaceChild(child, node);
                }
                ++i;
            }
        }
        if (href != null) {
            usedIds.remove(href);
        }
        return resolvedElement;
    }

    private static class URIReference {
        private Element ref_;
        private boolean resolved_;

        public URIReference(Element ref, boolean resolved) {
            this.ref_ = ref;
            this.resolved_ = resolved;
        }

        public Element getRefElement() {
            return this.ref_;
        }

        public void setRefElement(Element ref) {
            this.ref_ = ref;
        }

        public boolean getResolved() {
            return this.resolved_;
        }

        public void setResolved(boolean resolved) {
            this.resolved_ = resolved;
        }
    }
}

