/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.reference.ModifiableBooleanReference;
import org.eclipse.jpt.common.utility.tests.internal.reference.BooleanReferenceTests;

public abstract class ModifiableBooleanReferenceTests
extends BooleanReferenceTests {
    public ModifiableBooleanReferenceTests(String name) {
        super(name);
    }

    protected ModifiableBooleanReference buildBooleanReference() {
        return (ModifiableBooleanReference)super.buildBooleanReference();
    }

    protected abstract ModifiableBooleanReference buildBooleanReference(boolean var1);

    public void testSetValue() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        br.setValue(false);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testFlip() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.flip());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.flip());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testAnd() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.and(true));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.and(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.and(true));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.and(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testOr() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.or(true));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.or(false));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.setValue(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.or(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.or(true));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testXor() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.xor(true));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.setValue(true));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.xor(false));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.setValue(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.xor(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.setValue(false));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.xor(true));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetNotBoolean() {
        ModifiableBooleanReference br = this.buildBooleanReference(false);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(true);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(true);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setNot(false);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetTrue() {
        ModifiableBooleanReference br = this.buildBooleanReference(false);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        br.setTrue();
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSetFalse() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        br.setFalse();
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testCommit() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.commit(false, true));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.commit(false, true));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.commit(true, false));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.commit(true, false));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.commit(false, false));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.setValue(false));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.commit(true, true));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br.getValue());
    }

    public void testSwap_sameObject() {
        ModifiableBooleanReference br = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.swap(br));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testSwap_sameValues() {
        ModifiableBooleanReference br1 = this.buildBooleanReference(true);
        ModifiableBooleanReference br2 = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br1.swap(br2));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br1.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br2.getValue());
    }

    public void testSwap_differentValues1() {
        ModifiableBooleanReference br1 = this.buildBooleanReference(true);
        ModifiableBooleanReference br2 = this.buildBooleanReference(false);
        ModifiableBooleanReferenceTests.assertFalse((boolean)br1.swap(br2));
        ModifiableBooleanReferenceTests.assertFalse((boolean)br1.getValue());
        ModifiableBooleanReferenceTests.assertTrue((boolean)br2.getValue());
    }

    public void testSwap_differentValues2() {
        ModifiableBooleanReference br1 = this.buildBooleanReference(false);
        ModifiableBooleanReference br2 = this.buildBooleanReference(true);
        ModifiableBooleanReferenceTests.assertTrue((boolean)br1.swap(br2));
        ModifiableBooleanReferenceTests.assertTrue((boolean)br1.getValue());
        ModifiableBooleanReferenceTests.assertFalse((boolean)br2.getValue());
    }
}

