/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.IWebServiceChildList;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.Dom2ResourceMapper;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceProblemsDecorator
extends ProblemsLabelDecorator {
    private static final String THIS_DECORATOR_ID = "org.eclipse.jst.ws.jaxws.dom.integration.navigator.WebServiceDecorator";
    private static final String APT_MARKER_ID = "org.eclipse.jdt.apt.core.compile.problem";
    private static final String APT_NONRECONCILE_MARKER_ID = "org.eclipse.jdt.apt.core.nonreconcile.compile.problem";
    private DomUtil domUtil = DomUtil.INSTANCE;
    private final Dom2ResourceMapper dom2ResourceMapper = Dom2ResourceMapper.INSTANCE;

    public WebServiceProblemsDecorator() {
        this.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PlatformUI.getWorkbench().getDecoratorManager().update(WebServiceProblemsDecorator.THIS_DECORATOR_ID);
                    }
                });
            }
        });
    }

    protected int computeAdornmentFlags(Object obj) {
        Severity severity = this.defineSeverity(obj);
        if (severity == Severity.ERROR) {
            return 64;
        }
        if (severity == Severity.WARNING) {
            return 32;
        }
        return 0;
    }

    protected Severity defineSeverity(Object obj) {
        try {
            if (obj instanceof IWebServiceChildList) {
                return this.defineSeverityForEList((List<? extends EObject>)((IWebServiceChildList)obj).getWSChildList());
            }
            if (obj instanceof ISEIChildList) {
                return this.defineSeverityForEList((List<? extends EObject>)((ISEIChildList)obj).getSEIChildList());
            }
            if (!(obj instanceof EObject)) {
                return Severity.OK;
            }
            return this.defineSeverity((EObject)obj);
        }
        catch (CoreException e) {
            new Logger().logError(e.getMessage(), (Throwable)e);
            return Severity.OK;
        }
    }

    protected Severity defineSeverityForEList(List<? extends EObject> list) throws CoreException {
        Severity severity = Severity.OK;
        for (EObject eObject : list) {
            Severity tempSeverity = this.defineSeverity(eObject);
            if (tempSeverity == Severity.ERROR) {
                return Severity.ERROR;
            }
            if (tempSeverity != Severity.WARNING) continue;
            severity = Severity.WARNING;
        }
        return severity;
    }

    protected Severity defineSeverity(EObject eObject) throws CoreException {
        IResource resource = Dom2ResourceMapper.INSTANCE.findResource(eObject);
        if (resource != null) {
            return this.defineSeverity(eObject, resource);
        }
        return Severity.OK;
    }

    protected Severity defineSeverity(EObject eObject, IResource resource) throws CoreException {
        IServiceEndpointInterface sei;
        if (!resource.isAccessible()) {
            return Severity.OK;
        }
        int depth = resource.getType() == 4 ? 2 : 0;
        Collection<IMarker> markers = this.findAptMarkers(resource, depth);
        Severity severity = Severity.OK;
        for (IMarker marker : markers) {
            if (!this.isRelevantFor(eObject, marker)) continue;
            int tempSeverity = (Integer)marker.getAttribute("severity");
            if (tempSeverity == 2) {
                return Severity.ERROR;
            }
            if (tempSeverity != 1) continue;
            severity = Severity.WARNING;
        }
        if (severity == Severity.OK && eObject instanceof IWebService && (sei = ((IWebService)eObject).getServiceEndpoint()) != null && !sei.isImplicit()) {
            severity = this.defineSeverity((EObject)sei);
        }
        return severity;
    }

    protected boolean isRelevantFor(EObject eObject, IMarker marker) throws CoreException {
        switch (eObject.eClass().getClassifierID()) {
            case 3: {
                return this.isRelevantForMethod((IWebMethod)eObject, marker);
            }
            case 4: {
                return this.isRelevantForParameter((IWebParam)eObject, marker);
            }
        }
        return true;
    }

    protected boolean isRelevantForMethod(IWebMethod webMethod, IMarker marker) throws CoreException {
        IAnnotationInspector annotationInspector;
        IType type = this.dom2ResourceMapper.findType((EObject)webMethod);
        IMethod javaMethod = this.domUtil.findMethod(type, webMethod);
        boolean relevant = this.isMarkerRelevantFor(javaMethod, marker, annotationInspector = AnnotationFactory.createAnnotationInspector((IType)type));
        if (!relevant) {
            String[] stringArray = javaMethod.getParameterNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String methodParameterName = stringArray[n2];
                ITypeParameter param = javaMethod.getTypeParameter(methodParameterName);
                relevant = relevant || this.isMarkerRelevantFor(param, marker, annotationInspector);
                ++n2;
            }
        }
        return relevant;
    }

    protected boolean isRelevantForParameter(IWebParam webParam, IMarker marker) throws CoreException {
        IType type = this.dom2ResourceMapper.findType((EObject)webParam);
        ITypeParameter javaParameter = this.findJavaParameter(type, webParam);
        return this.isMarkerRelevantFor(javaParameter, marker, AnnotationFactory.createAnnotationInspector((IType)type));
    }

    private ITypeParameter findJavaParameter(IType type, IWebParam webParam) throws JavaModelException {
        IMethod javaMethod = this.domUtil.findMethod(type, (IWebMethod)webParam.eContainer());
        String[] stringArray = javaMethod.getParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            ITypeParameter javaParam = javaMethod.getTypeParameter(paramName);
            if (webParam.getImplementation().equals(javaParam.getElementName())) {
                return javaParam;
            }
            ++n2;
        }
        throw new IllegalStateException("Parameter " + webParam.getImplementation() + " not found");
    }

    private boolean isMarkerRelevantFor(IMethod javaMethod, IMarker marker, IAnnotationInspector inspector) throws CoreException {
        for (IAnnotation ann : inspector.inspectMethod(javaMethod)) {
            if (!this.isMarkerRelevantToAnnotation(marker, (IAnnotation<? extends IJavaElement>)ann)) continue;
            return true;
        }
        return false;
    }

    private boolean isMarkerRelevantFor(ITypeParameter parameter, IMarker marker, IAnnotationInspector inspector) throws CoreException {
        for (IAnnotation ann : inspector.inspectParam(parameter)) {
            if (!this.isMarkerRelevantToAnnotation(marker, (IAnnotation<? extends IJavaElement>)ann)) continue;
            return true;
        }
        return false;
    }

    private boolean isMarkerRelevantToAnnotation(IMarker marker, IAnnotation<? extends IJavaElement> ann) throws CoreException {
        int annStartPos = ann.getLocator().getStartPosition();
        int annEndPos = annStartPos + ann.getLocator().getLength() - 1;
        return annStartPos <= (Integer)marker.getAttribute("charStart") && annEndPos >= (Integer)marker.getAttribute("charEnd");
    }

    private Collection<IMarker> findAptMarkers(IResource resource, int depth) throws CoreException {
        IMarker m;
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = resource.findMarkers(APT_MARKER_ID, false, depth);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = iMarkerArray[n2];
            result.add(m);
            ++n2;
        }
        iMarkerArray = resource.findMarkers(APT_NONRECONCILE_MARKER_ID, false, depth);
        n = iMarkerArray.length;
        n2 = 0;
        while (n2 < n) {
            m = iMarkerArray[n2];
            result.add(m);
            ++n2;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        OK,
        ERROR,
        WARNING;

    }
}

