/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.wizards;

import java.util.Collection;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;

public class CXFFacetInstallWizardPage
extends AbstractFacetWizardPage {
    private CXFDataModel dataModel;
    private CXFContext cxfContext;
    private ComboViewer installationsComboViewer;

    public CXFFacetInstallWizardPage() {
        super("cxf.core.facet.install.page");
        this.setTitle(CXFUIMessages.CXF_FACET_INSTALL_WIZARD_PAGE_TITLE);
        this.setDescription(CXFUIMessages.CXF_FACET_INSTALL_WIZARD_PAGE_DESCRIPTION);
        this.cxfContext = CXFCorePlugin.getDefault().getJava2WSContext();
    }

    public void setConfig(Object config) {
        this.dataModel = (CXFDataModel)config;
    }

    public void transferStateToConfig() {
        StructuredSelection structuredSelection = (StructuredSelection)this.installationsComboViewer.getSelection();
        CXFInstall selectedInstall = (CXFInstall)structuredSelection.getFirstElement();
        if (selectedInstall != null) {
            this.dataModel.setDefaultRuntimeVersion(selectedInstall.getVersion());
            this.dataModel.setDefaultRuntimeLocation(selectedInstall.getLocation());
            this.dataModel.setDefaultRuntimeType(selectedInstall.getType());
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        Link link = new Link(composite, 131072);
        link.setText(CXFUIMessages.CXF_CONFIGURE_INSTALLED_RUNTIMES_LABEL);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CXFFacetInstallWizardPage.this.installationsComboViewer.getCombo().getSelectionIndex();
                int result = PreferencesUtil.createPreferenceDialogOn((Shell)CXFFacetInstallWizardPage.this.getShell(), (String)"org.eclipse.jst.ws.cxf.ui.CXFRuntimePreferencesPage", (String[])new String[]{"org.eclipse.jst.ws.cxf.ui.CXFRuntimePreferencesPage"}, null).open();
                if (result == 0) {
                    CXFFacetInstallWizardPage.this.installationsComboViewer.refresh();
                    CXFFacetInstallWizardPage.this.setDefault();
                }
            }
        });
        GridData gridData = new GridData(0x1000008, 4, true, false);
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(CXFUIMessages.CXF_PROPERTY_PAGE_RUNTIME_LABEL);
        this.installationsComboViewer = new ComboViewer(composite, 2056);
        gridData = new GridData(4, 4, true, false);
        this.installationsComboViewer.getCombo().setLayoutData((Object)gridData);
        this.installationsComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.installationsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CXFInstall) {
                    CXFInstall cxfInstall = (CXFInstall)element;
                    return String.valueOf(cxfInstall.getType()) + " " + cxfInstall.getVersion();
                }
                return "";
            }
        });
        Collection installations = this.cxfContext.getInstallations().values();
        this.installationsComboViewer.setInput(installations);
        this.setDefault();
        this.setControl((Control)composite);
    }

    private void setDefault() {
        String intalledVersion = CXFCorePlugin.getDefault().getJava2WSContext().getDefaultRuntimeVersion();
        CXFInstall defaultInstall = (CXFInstall)this.cxfContext.getInstallations().get(intalledVersion);
        if (defaultInstall != null) {
            this.installationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)defaultInstall), true);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }
}

