/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.ApplicationDeploymentDescriptor;
import org.eclipse.jst.javaee.application.ApplicationFactory;
import org.eclipse.jst.javaee.application.IApplicationResource;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.jee.model.internal.JEE5ModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EAR5ModelProvider
extends JEE5ModelProvider
implements IEARModelProvider {
    private static final String EAR5_CONTENT_TYPE = "org.eclipse.jst.jee.ee5earDD";

    public EAR5ModelProvider(IProject proj) {
        this.proj = proj;
        this.setDefaultResourcePath((IPath)new Path("META-INF/application.xml"));
    }

    protected String getContentTypeDescriber() {
        return EAR5_CONTENT_TYPE;
    }

    public Object getModelObject(IPath modelPath) {
        IApplicationResource earRes = (IApplicationResource)this.getModelResource(modelPath);
        if (earRes != null && earRes.getRootObject() != null) {
            return earRes.getApplication();
        }
        return null;
    }

    public String getModuleURI(IVirtualComponent moduleComp) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.proj);
        IVirtualReference[] refs = comp.getReferences();
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getDependencyType() == 0 && refs[i].getReferencedComponent().equals(moduleComp)) {
                return refs[i].getArchiveName();
            }
            ++i;
        }
        return null;
    }

    public String getWebContextRoot(IProject webProject) {
        Module webModule;
        if (webProject == null || !JavaEEProjectUtilities.isDynamicWebProject((IProject)webProject)) {
            return null;
        }
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        String webModuleURI = this.getModuleURI(webComp);
        if (webModuleURI != null && (webModule = ((Application)this.getModelObject()).getModule(webModuleURI, null)) != null) {
            return webModule.getWeb().getContextRoot();
        }
        return null;
    }

    public void populateRoot(XMLResourceImpl res, String name) {
        ApplicationDeploymentDescriptor dd = ApplicationFactory.eINSTANCE.createApplicationDeploymentDescriptor();
        dd.getXMLNSPrefixMap().put("", "http://java.sun.com/xml/ns/javaee");
        dd.getXMLNSPrefixMap().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Application ear = ApplicationFactory.eINSTANCE.createApplication();
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        ear.getDisplayNames().add(dn);
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.proj);
        if (version != null && version.equals("5.0")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application_5.xsd");
            ear.setVersion("5");
        } else if (version != null && version.equals("6.0")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application_6.xsd");
            ear.setVersion("6");
        } else if (version != null && version.equals("7.0")) {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/application_7.xsd");
            ear.setVersion("7");
        } else if (version != null && version.equals("10.0")) {
            dd.getXMLNSPrefixMap().put("", "https://jakarta.ee/xml/ns/jakartaee");
            dd.getXSISchemaLocation().put("https://jakarta.ee/xml/ns/jakartaee", "https://jakarta.ee/xml/ns/jakartaee/application_10.xsd");
            ear.setVersion("10");
        } else {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/application_8.xsd");
            ear.setVersion("8");
        }
        dd.setApplication(ear);
        res.getContents().add((Object)((EObject)dd));
    }

    public void setWebContextRoot(IProject webProject, String aContextRoot) {
        WebModule webModule;
        if (webProject == null || !JavaEEProjectUtilities.isDynamicWebProject((IProject)webProject)) {
            return;
        }
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        String webModuleURI = this.getModuleURI(webComp);
        if (webModuleURI != null && (webModule = (WebModule)((Application)this.getModelObject()).getModule(webModuleURI, null)) != null) {
            webModule.setContextRoot(aContextRoot);
        }
    }
}

