/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationListIterator<E1, E2>
implements ListIterator<E2> {
    private final ListIterator<? extends E1> listIterator;
    private final Transformer<? super E1, ? extends E2> transformer;

    public TransformationListIterator(ListIterator<? extends E1> listIterator, Transformer<? super E1, ? extends E2> transformer) {
        if (listIterator == null || transformer == null) {
            throw new NullPointerException();
        }
        this.listIterator = listIterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public E2 next() {
        return this.transformer.transform(this.listIterator.next());
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public E2 previous() {
        return this.transformer.transform(this.listIterator.previous());
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void add(E2 o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E2 o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this.listIterator.remove();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.listIterator);
    }
}

