/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt;

import org.eclipse.jpt.common.ui.internal.swt.SpinnerModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpinnerModelAdapterTest {
    private Model model;
    private Shell shell;
    private ModifiablePropertyValueModel<Model> subjectHolder;

    private ModifiablePropertyValueModel<Model> buildSubjectHolder() {
        return new SimplePropertyValueModel();
    }

    private ModifiablePropertyValueModel<Integer> buildValueHolder() {
        return new PropertyAspectAdapter<Model, Integer>(this.subjectHolder, new String[]{"value"}){

            protected Integer buildValue_() {
                return ((Model)((Object)this.subject)).getValue();
            }

            protected void setValue_(Integer value) {
                ((Model)((Object)this.subject)).setValue(value);
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell(Display.getCurrent());
        this.model = new Model();
        this.subjectHolder = this.buildSubjectHolder();
    }

    @After
    public void tearDown() throws Exception {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
        this.subjectHolder = null;
    }

    @Test
    public void testDisposed() {
        int value = 2;
        this.model.setValue(value);
        this.model.clearSetValueCalledFlag();
        this.subjectHolder.setValue((Object)this.model);
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ModifiablePropertyValueModel<Integer> numberHolder = this.buildValueHolder();
        int defaultValue = 1;
        SpinnerModelAdapter.adapt(numberHolder, (Spinner)spinner, (int)defaultValue);
        Assert.assertEquals((String)"The spinner's value should be coming from the model", (long)value, (long)spinner.getSelection());
        Assert.assertEquals((String)"The number holder's value should be the model's value", (Object)this.model.getValue(), (Object)numberHolder.getValue());
        Assert.assertFalse((String)"The model should not have received the value during initialization", (boolean)this.model.isSetValueCalled());
        spinner.dispose();
        value = 4;
        this.model.setValue(value);
        Assert.assertEquals((String)"The model's value was somehow changed", (Object)value, (Object)this.model.getValue());
    }

    @Test
    public void testInitialization_1() {
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        SimplePropertyValueModel numberHolder = new SimplePropertyValueModel();
        int defaultValue = 1;
        SpinnerModelAdapter.adapt((ModifiablePropertyValueModel)numberHolder, (Spinner)spinner, (int)defaultValue);
        Assert.assertEquals((String)"The spinner's value should be the default value", (long)defaultValue, (long)spinner.getSelection());
        Assert.assertNull((String)"The number holder's value should be null", (Object)numberHolder.getValue());
    }

    @Test
    public void testInitialization_2() {
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ModifiablePropertyValueModel<Integer> numberHolder = this.buildValueHolder();
        int defaultValue = 1;
        SpinnerModelAdapter.adapt(numberHolder, (Spinner)spinner, (int)defaultValue);
        Assert.assertEquals((String)"The spinner's value should be the default value", (long)defaultValue, (long)spinner.getSelection());
        Assert.assertNull((String)"The number holder's value should be null", (Object)numberHolder.getValue());
    }

    @Test
    public void testInitialization_3() {
        this.subjectHolder.setValue((Object)this.model);
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ModifiablePropertyValueModel<Integer> numberHolder = this.buildValueHolder();
        int defaultValue = 1;
        SpinnerModelAdapter.adapt(numberHolder, (Spinner)spinner, (int)defaultValue);
        Assert.assertEquals((String)"The spinner's value should be the default value", (long)defaultValue, (long)spinner.getSelection());
        Assert.assertNull((String)"The number holder's value should be null", (Object)numberHolder.getValue());
        Assert.assertFalse((String)"The model should not have received the value during initialization", (boolean)this.model.isSetValueCalled());
    }

    @Test
    public void testInitialization_4() {
        int value = 2;
        this.model.setValue(value);
        this.model.clearSetValueCalledFlag();
        this.subjectHolder.setValue((Object)this.model);
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ModifiablePropertyValueModel<Integer> numberHolder = this.buildValueHolder();
        int defaultValue = 1;
        SpinnerModelAdapter.adapt(numberHolder, (Spinner)spinner, (int)defaultValue);
        Assert.assertEquals((String)"The spinner's value should be the value coming from the model", (long)value, (long)spinner.getSelection());
        Assert.assertEquals((String)("The number holder's value should be " + value), (Object)value, (Object)numberHolder.getValue());
        Assert.assertFalse((String)"The model should not have received the value during initialization", (boolean)this.model.isSetValueCalled());
    }

    @Test
    public void testValueChanged() {
        int value = 2;
        this.model.setValue(value);
        this.model.clearSetValueCalledFlag();
        this.subjectHolder.setValue((Object)this.model);
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ModifiablePropertyValueModel<Integer> numberHolder = this.buildValueHolder();
        int defaultValue = 1;
        SpinnerModelAdapter.adapt(numberHolder, (Spinner)spinner, (int)defaultValue);
        Assert.assertEquals((String)"The spinner's value should be coming from the model", (long)value, (long)spinner.getSelection());
        Assert.assertEquals((String)"The number holder's value should be the model's value", (Object)this.model.getValue(), (Object)numberHolder.getValue());
        Assert.assertFalse((String)"The model should not have received the value during initialization", (boolean)this.model.isSetValueCalled());
        value = 4;
        this.model.setValue(value);
        Assert.assertEquals((String)"The spinner's value should be coming from the model", (long)value, (long)spinner.getSelection());
        Assert.assertEquals((String)"The model's value was somehow changed", (Object)value, (Object)this.model.getValue());
        value = 6;
        spinner.setSelection(value);
        Assert.assertEquals((String)"The spinner's value should be the new value set", (long)value, (long)spinner.getSelection());
        Assert.assertEquals((String)"The model's value was supposed to be updated", (Object)value, (Object)this.model.getValue());
        this.subjectHolder.setValue(null);
        Assert.assertEquals((String)"The spinner's value should be the default value", (long)defaultValue, (long)spinner.getSelection());
    }

    private static class Model
    extends AbstractModel {
        private boolean setValueCalled;
        private Integer value;
        static final String VALUE_PROPERTY = "value";

        private Model() {
        }

        void clearSetValueCalledFlag() {
            this.setValueCalled = false;
        }

        Integer getValue() {
            return this.value;
        }

        boolean isSetValueCalled() {
            return this.setValueCalled;
        }

        void setValue(Integer value) {
            this.setValueCalled = true;
            Integer oldValue = this.value;
            this.value = value;
            this.firePropertyChanged(VALUE_PROPERTY, oldValue, value);
        }
    }
}

