/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.BufferChangedEvent;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferChangedListener;
import org.eclipse.wst.jsdt.core.IOpenable;

public class TestBuffer
implements IBuffer {
    IOpenable owner;
    ArrayList changeListeners;
    char[] contents = null;
    boolean hasUnsavedChanges = false;

    public TestBuffer(IOpenable owner) {
        this.owner = owner;
    }

    public void addBufferChangedListener(IBufferChangedListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(5);
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void append(char[] text) {
        this.hasUnsavedChanges = true;
    }

    public void append(String text) {
        this.hasUnsavedChanges = true;
    }

    public void close() {
        this.contents = null;
        if (this.changeListeners != null) {
            BufferChangedEvent event = null;
            event = new BufferChangedEvent((IBuffer)this, 0, 0, null);
            int i = 0;
            int size = this.changeListeners.size();
            while (i < size) {
                IBufferChangedListener listener = (IBufferChangedListener)this.changeListeners.get(i);
                listener.bufferChanged(event);
                ++i;
            }
            this.changeListeners = null;
        }
    }

    public char getChar(int position) {
        return '\u0000';
    }

    public char[] getCharacters() {
        return this.contents;
    }

    public String getContents() {
        return new String(this.contents);
    }

    public int getLength() {
        return this.contents.length;
    }

    public IOpenable getOwner() {
        return this.owner;
    }

    public String getText(int offset, int length) {
        return null;
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    public boolean isClosed() {
        return this.contents == null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void removeBufferChangedListener(IBufferChangedListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    public void replace(int position, int length, char[] text) {
        this.hasUnsavedChanges = true;
    }

    public void replace(int position, int length, String text) {
        this.hasUnsavedChanges = true;
    }

    public void save(IProgressMonitor progress, boolean force) {
        this.hasUnsavedChanges = false;
    }

    public void setContents(char[] characters) {
        this.contents = characters;
        this.hasUnsavedChanges = true;
    }

    public void setContents(String characters) {
        this.contents = characters.toCharArray();
        this.hasUnsavedChanges = true;
    }
}

