/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.document;

import org.eclipse.wst.json.core.TestUtil;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Assert;
import org.junit.Test;

public class JSONObjectDocumentChangesTest {
    @Test
    public void insertCloseObject() {
        IJSONModel model = TestUtil.loadModel("{");
        IJSONDocument document = model.getDocument();
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object = (IJSONObject)document.getFirstChild();
        Assert.assertFalse((boolean)object.isClosed());
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.replaceText((Object)structuredDocument, 1, 0, "}");
        object = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object.isClosed());
    }

    @Test
    public void removeObject() {
        IJSONModel model = TestUtil.loadModel("{}");
        IJSONDocument document = model.getDocument();
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object.isClosed());
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.replaceText((Object)structuredDocument, 0, 2, "");
        Assert.assertNull((Object)document.getFirstChild());
    }

    @Test
    public void insertSpaces() {
        IJSONModel model = TestUtil.loadModel("{}");
        IJSONDocument document = model.getDocument();
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object.isClosed());
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.replaceText((Object)structuredDocument, 1, 0, "\r\n");
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object2 = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object2.isClosed());
    }

    @Test
    public void insertPair() {
        IJSONModel model = TestUtil.loadModel("{}");
        IJSONDocument document = model.getDocument();
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object.isClosed());
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        structuredDocument.replaceText((Object)structuredDocument, 1, 0, "\"\"");
        Assert.assertNotNull((Object)document.getFirstChild());
        Assert.assertTrue((boolean)(document.getFirstChild() instanceof IJSONObject));
        IJSONObject object2 = (IJSONObject)document.getFirstChild();
        Assert.assertTrue((boolean)object2.isClosed());
        Assert.assertTrue((boolean)(object2.getFirstChild() instanceof IJSONPair));
        IJSONPair pair = (IJSONPair)object2.getFirstChild();
        Assert.assertEquals((Object)"", (Object)pair.getName());
        Assert.assertNull((Object)pair.getValue());
        structuredDocument.replaceText((Object)structuredDocument, 3, 0, ":");
        Assert.assertTrue((boolean)(document.getFirstChild().getFirstChild() instanceof IJSONPair));
        pair = (IJSONPair)((IJSONObject)document.getFirstChild()).getFirstChild();
        Assert.assertTrue((boolean)(pair instanceof IJSONPair));
        Assert.assertEquals((Object)"", (Object)pair.getName());
        Assert.assertNull((Object)pair.getValue());
        structuredDocument.replaceText((Object)structuredDocument, 4, 0, "{}");
        Assert.assertTrue((boolean)(document.getFirstChild().getFirstChild() instanceof IJSONPair));
        pair = (IJSONPair)((IJSONObject)document.getFirstChild()).getFirstChild();
        Assert.assertTrue((boolean)(pair instanceof IJSONPair));
        Assert.assertEquals((Object)"", (Object)pair.getName());
        Assert.assertNotNull((Object)pair.getValue());
        structuredDocument.replaceText((Object)structuredDocument, 2, 0, "a");
        Assert.assertTrue((boolean)(document.getFirstChild().getFirstChild() instanceof IJSONPair));
        pair = (IJSONPair)((IJSONObject)document.getFirstChild()).getFirstChild();
        Assert.assertTrue((boolean)(pair instanceof IJSONPair));
        Assert.assertEquals((Object)"a", (Object)pair.getName());
        Assert.assertNotNull((Object)pair.getValue());
    }
}

