/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RadiosDialogField
extends DialogFieldBase {
    private static final String INDEXKEY = "INDEX";
    private Composite _group;
    private String[] _items;
    private Button[] _button;
    private int _selectIndex = -1;
    private boolean _fireEvent = true;

    public void setItems(String[] items) {
        this._items = items;
        this._button = new Button[this._items.length];
    }

    @Override
    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)RadiosDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)RadiosDialogField.gridDataForLabel(1));
        this._group = this.getGroup(toolkit, parent);
        this._group.setLayoutData((Object)RadiosDialogField.gridDataForGroup(nColumns - 2));
        return new Control[]{requiredLabel, label, this._group};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForGroup(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this._group)) {
            this._group.setFocus();
        }
        return true;
    }

    public Composite getGroup(FormToolkit toolkit, Composite parent) {
        if (this._group == null || this._group.isDisposed()) {
            this.assertCompositeNotNull(parent);
            this._group = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
            RowLayout layout = new RowLayout();
            layout.marginBottom = 0;
            this._group.setLayout((Layout)layout);
            int i = 0;
            while (i < this._items.length) {
                if (toolkit != null) {
                    this._button[i] = toolkit.createButton(this._group, this._items[i], 16);
                } else {
                    this._button[i] = new Button(this._group, 16);
                    this._button[i].setText(this._items[i]);
                }
                this._button[i].setData(INDEXKEY, (Object)new Integer(i));
                this._button[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (RadiosDialogField.this._fireEvent) {
                            RadiosDialogField.this._selectIndex = (Integer)e.widget.getData(RadiosDialogField.INDEXKEY);
                            if (((Button)e.widget).getSelection()) {
                                RadiosDialogField.this.dialogFieldChangedAndApplied();
                            }
                        }
                    }
                });
                ++i;
            }
        }
        return this._group;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this._group)) {
            this._group.setEnabled(this.isEnabled());
        }
    }

    public void setSelectedIndex(int index) {
        this._selectIndex = index;
        if (this.isOkToUse((Control)this._group)) {
            if (this._selectIndex >= 0 && this._selectIndex < this._items.length) {
                this._button[this._selectIndex].setSelection(true);
            } else {
                int i = 0;
                while (i < this._items.length) {
                    if (this._button[i].getSelection()) {
                        this._button[i].setSelection(false);
                    }
                    ++i;
                }
            }
        }
        this.dialogFieldChangedAndApplied();
    }

    public void setSelectedIndexWithoutUpdate(int index) {
        this._selectIndex = index;
        if (this.isOkToUse((Control)this._group)) {
            this._fireEvent = false;
            if (this._selectIndex >= 0 && this._selectIndex < this._items.length) {
                this._button[this._selectIndex].setSelection(true);
            } else {
                int i = 0;
                while (i < this._items.length) {
                    if (this._button[i].getSelection()) {
                        this._button[i].setSelection(false);
                    }
                    ++i;
                }
            }
            this._fireEvent = true;
        }
    }

    public int getSelectedIndex() {
        return this._selectIndex;
    }

    @Override
    public void handleGrabHorizontal() {
        LayoutUtil.setGrabHorizontal((Control)this._group, true);
    }
}

