/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;

public class JavaScriptWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        WatchResult result = new WatchResult(expression);
        try {
            try {
                IStackFrame fcontext = this.getFrameContext(context);
                if (fcontext instanceof IJavaScriptStackFrame) {
                    IJavaScriptStackFrame frame = (IJavaScriptStackFrame)fcontext;
                    result.value = frame.evaluate(expression);
                }
            }
            catch (DebugException de) {
                result.exception = de;
                result.errormessages = new String[]{de.getMessage()};
                listener.watchEvaluationFinished((IWatchExpressionResult)result);
            }
        }
        finally {
            listener.watchEvaluationFinished((IWatchExpressionResult)result);
        }
    }

    IStackFrame getFrameContext(IDebugElement element) throws DebugException {
        if (element instanceof IStackFrame) {
            return (IStackFrame)element;
        }
        if (element instanceof IThread) {
            return ((IThread)element).getTopStackFrame();
        }
        return null;
    }

    class WatchResult
    implements IWatchExpressionResult {
        String expression = null;
        IValue value = null;
        String[] errormessages = null;
        DebugException exception = null;

        public WatchResult(String expression) {
            this.expression = expression;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return this.errormessages != null || this.exception != null;
        }

        public String[] getErrorMessages() {
            return this.errormessages;
        }

        public String getExpressionText() {
            return this.expression;
        }

        public DebugException getException() {
            return this.exception;
        }
    }
}

