/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseNodeFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.FigureConstants;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IBaseFigure;
import org.eclipse.swt.graphics.Rectangle;

class PortFigure
extends Figure {
    private boolean showBox = false;
    private boolean showArrow = true;
    private int orientation = 8;
    private int type = FigureConstants.INPUT_PORT;

    public PortFigure(int type) {
        this.type = type;
        this.setOpaque(false);
    }

    public void setBoxVisible(boolean b) {
        this.showBox = b;
        this.repaint();
    }

    public void setArrowVisible(boolean b) {
        this.showArrow = b;
        this.repaint();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setToolTipText(String text) {
        this.setToolTip((IFigure)new Label(text));
    }

    public String getToolTipText() {
        IFigure fig = this.getToolTip();
        if (fig instanceof Label) {
            return ((Label)fig).getText();
        }
        return null;
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        org.eclipse.draw2d.geometry.Rectangle bounds_ = this.getBounds();
        g.setForegroundColor(this.getForegroundColor());
        if (this.showBox) {
            g.setBackgroundColor(this.getBackgroundColor());
            g.fillRectangle(this.getBounds().getCropped(new Insets(0, 1, 1, 0)));
            org.eclipse.draw2d.geometry.Rectangle r = this.getBounds().getExpanded(-1, -1).getTranslated(0, -1);
            ++r.height;
            g.drawRectangle(r);
        }
        if (this.showArrow) {
            g.setBackgroundColor(this.getForegroundColor());
            PointList pts = new PointList();
            if (this.type == FigureConstants.INPUT_PORT) {
                switch (this.orientation) {
                    case 1: {
                        pts.addPoint(bounds_.getTopLeft());
                        pts.addPoint(bounds_.getTopRight());
                        pts.addPoint(bounds_.getBottom());
                        pts.addPoint(bounds_.getTopLeft());
                        break;
                    }
                    case 4: {
                        pts.addPoint(bounds_.getBottomLeft());
                        pts.addPoint(bounds_.getTop());
                        pts.addPoint(bounds_.getBottomRight());
                        pts.addPoint(bounds_.getBottomLeft());
                        break;
                    }
                    case 16: {
                        pts.addPoint(bounds_.getTopRight());
                        pts.addPoint(bounds_.getBottomRight());
                        pts.addPoint(bounds_.getLeft());
                        pts.addPoint(bounds_.getTopRight());
                        break;
                    }
                    case 8: {
                        pts.addPoint(bounds_.getTopLeft());
                        pts.addPoint(bounds_.getRight());
                        pts.addPoint(bounds_.getBottomLeft());
                        pts.addPoint(bounds_.getTopLeft());
                    }
                }
            } else {
                switch (this.orientation) {
                    case 1: {
                        pts.addPoint(bounds_.getBottomLeft());
                        pts.addPoint(bounds_.getTop());
                        pts.addPoint(bounds_.getBottomRight());
                        pts.addPoint(bounds_.getBottomLeft());
                        break;
                    }
                    case 4: {
                        pts.addPoint(bounds_.getTopLeft());
                        pts.addPoint(bounds_.getTopRight());
                        pts.addPoint(bounds_.getBottom());
                        pts.addPoint(bounds_.getTopLeft());
                        break;
                    }
                    case 16: {
                        pts.addPoint(bounds_.getTopLeft());
                        pts.addPoint(bounds_.getRight());
                        pts.addPoint(bounds_.getBottomLeft());
                        pts.addPoint(bounds_.getTopLeft());
                        break;
                    }
                    case 8: {
                        pts.addPoint(bounds_.getTopRight());
                        pts.addPoint(bounds_.getBottomRight());
                        pts.addPoint(bounds_.getLeft());
                        pts.addPoint(bounds_.getTopRight());
                    }
                }
            }
            g.fillPolygon(pts);
            g.drawPolyline(pts);
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        IBaseFigure fig;
        Dimension d = new Dimension(10, 10);
        if (this.getParent() instanceof BaseNodeFigure && (fig = ((BaseNodeFigure)this.getParent()).getBaseFigure()) != null && fig.getIcon() != null) {
            Rectangle r = fig.getIcon().getBounds();
            if (r.width < 40) {
                d.width /= 2;
            }
            if (r.height < 40) {
                d.height /= 2;
            }
        }
        return d;
    }
}

