/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;
import org.junit.Assert;
import org.junit.Test;

public class TestElementCompletionProposal
extends AbstractSourceViewerTest {
    @Test
    public void testXSLPropsoalAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 16;
        int line = 5;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
    }

    @Test
    public void testXSLApplyTemplatesPropsoalAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument cfr_ignored_0 = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 13;
        int line = 6;
        ICompletionProposal[] proposals = this.getProposals(line, column);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        String proposalName = "";
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xsl:apply-templates")) {
                proposalName = proposals[cnt].getDisplayString();
            }
            ++cnt;
        }
        Assert.assertEquals((String)"Did not find expected proposal.", (Object)"xsl:apply-templates", (Object)proposalName);
    }

    @Test
    public void testXSLChoosePropsoalAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument cfr_ignored_0 = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 13;
        int line = 6;
        ICompletionProposal[] proposals = this.getProposals(line, column);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        String proposalName = "";
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xsl:choose")) {
                proposalName = proposals[cnt].getDisplayString();
            }
            ++cnt;
        }
        Assert.assertEquals((String)"Did not find expected proposal.", (Object)"xsl:choose", (Object)proposalName);
    }

    @Test
    public void testXSLWhenPropsoalNotAvailable() throws Exception {
        this.fileName = "testElementProposals.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int column = 16;
        int line = 5;
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        String proposalName = "";
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xsl:when")) {
                proposalName = proposals[cnt].getDisplayString();
            }
            ++cnt;
        }
        Assert.assertFalse((String)"xsl:when proposal found when it shouldn't have been.", (boolean)proposalName.equals("xsl:when"));
    }
}

