/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.extensions.soap.SOAPFault;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2032
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2032(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        BindingFault[] bindingFaults = this.validator.getAllBindingFaults(binding);
        if (bindingFaults == null || bindingFaults.length == 0) {
            this.result = "passed";
        } else {
            int i = 0;
            while (i < bindingFaults.length) {
                BindingFault bindingFault = bindingFaults[i];
                SOAPFault soapFault = this.validator.getSoapFault(bindingFault);
                if (soapFault == null || soapFault.getName() == null || bindingFault.getName() == null || !bindingFault.getName().equals(soapFault.getName())) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(soapFault == null ? null : soapFault.toString(), entryContext);
                    break;
                }
                ++i;
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

