/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.text;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.ui.internal.extensions.ExtensibleTypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelLocatorAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.text.WSDLModelReconcileAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaLocationResolverAdapterFactory;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLModelAdapter
implements INodeAdapter {
    protected ResourceSet resourceSet;
    protected Definition definition;
    private ModelReconcileAdapter modelReconcileAdapter;

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public boolean isAdapterForType(Object type) {
        return type == WSDLModelAdapter.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public Definition createDefinition(Element element, Document document) {
        return this.createDefinition(document);
    }

    public Definition createDefinition(final Document document) {
        try {
            IDOMNode domNode = (IDOMNode)document;
            String baseLocation = "blankWSDL.wsdl";
            if (domNode != null) {
                baseLocation = domNode.getModel().getBaseLocation();
            } else if (document instanceof IDOMNode) {
                IDOMModel domModel = ((IDOMNode)document).getModel();
                baseLocation = domModel.getBaseLocation();
            }
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getAdapterFactories().add((Object)new WSDLModelLocatorAdapterFactory());
            this.resourceSet.getAdapterFactories().add((Object)new XSDSchemaLocationResolverAdapterFactory());
            URI uri = null;
            uri = baseLocation.startsWith("/") ? URI.createPlatformResourceURI((String)baseLocation) : (baseLocation.startsWith("http") ? URI.createURI((String)baseLocation) : URI.createFileURI((String)baseLocation));
            this.definition = WSDLFactory.eINSTANCE.createDefinition();
            this.definition.setDocumentBaseURI(uri.toString());
            this.definition.setDocument(document);
            WSDLResourceFactoryImpl resourceFactory = new WSDLResourceFactoryImpl();
            Resource resource = resourceFactory.createResource(uri);
            this.resourceSet.getResources().add((Object)resource);
            resource.getContents().add((Object)this.definition);
            resource.setModified(false);
            IRunnableWithProgress setElementOperation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", -1);
                    Map loadOptions = WSDLModelAdapter.this.resourceSet.getLoadOptions();
                    loadOptions.put("WSDL_PROGRESS_MONITOR", monitor);
                    loadOptions.put(XSDResourceImpl.XSD_PROGRESS_MONITOR, monitor);
                    WSDLModelAdapter.this.definition.setElement(document.getDocumentElement());
                    ((DefinitionImpl)WSDLModelAdapter.this.definition).reconcileReferences(true);
                    loadOptions.remove("WSDL_PROGRESS_MONITOR");
                    loadOptions.remove(XSDResourceImpl.XSD_PROGRESS_MONITOR);
                }
            };
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.busyCursorWhile(setElementOperation);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.modelReconcileAdapter = new WSDLModelReconcileAdapter(document, this.definition);
            domNode.getModel().addModelStateListener((IModelStateListener)this.modelReconcileAdapter);
            WSDLEditorUtil.getInstance().setTypeSystemProvider(this.definition, new ExtensibleTypeSystemProvider());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.definition;
    }

    public ModelReconcileAdapter getModelReconcileAdapter() {
        return this.modelReconcileAdapter;
    }

    public static WSDLModelAdapter lookupOrCreateModelAdapter(Document document) {
        INodeNotifier notifier;
        WSDLModelAdapter adapter = null;
        if (document instanceof INodeNotifier && (adapter = (WSDLModelAdapter)(notifier = (INodeNotifier)document).getAdapterFor(WSDLModelAdapter.class)) == null) {
            adapter = new WSDLModelAdapter();
            notifier.addAdapter((INodeAdapter)adapter);
        }
        return adapter;
    }

    public void clear() {
        if (this.definition != null) {
            Document doc = this.definition.getDocument();
            if (doc instanceof IDOMDocument) {
                IDOMDocument domDocument = (IDOMDocument)doc;
                domDocument.getModel().removeModelStateListener((IModelStateListener)this.getModelReconcileAdapter());
                domDocument.removeAdapter((INodeAdapter)this.getModelReconcileAdapter());
                domDocument.removeAdapter((INodeAdapter)this);
            }
            this.definition = null;
        }
        this.resourceSet = null;
    }
}

