/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.util.Vector;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.SelectWSDLPropertiesToolAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;

public class OpenWSDLAction
extends WSDLPropertiesFormAction {
    public OpenWSDLAction(Controller controller) {
        super(controller);
    }

    @Override
    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String wsdlUrl = parser.getParameter("wsdlURL");
        FormTool formTool = this.getSelectedFormTool();
        this.propertyTable_.put("wsdlURL", wsdlUrl);
        formTool.updatePropertyTable(this.propertyTable_);
        return true;
    }

    @Override
    public boolean run() {
        String wsdlUrl = (String)this.propertyTable_.get("wsdlURL");
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        MessageQueue messageQueue = wsdlPerspective.getMessageQueue();
        NodeManager nodeManager = wsdlPerspective.getNodeManager();
        Node rootNode = nodeManager.getRootNode();
        TreeElement rootElement = rootNode.getTreeElement();
        WSDLElement wsdlElement = new WSDLElement(wsdlUrl, rootElement.getModel(), wsdlUrl);
        try {
            Vector errorMessages = wsdlElement.loadWSDL();
            if (errorMessages.size() > 0) {
                messageQueue.addMessage(wsdlPerspective.getMessage("MSG_ERROR_XSD_VALIDATION"));
                int i = 0;
                while (i < errorMessages.size()) {
                    messageQueue.addMessage((String)errorMessages.elementAt(i));
                    ++i;
                }
            }
        }
        catch (WSDLException e) {
            messageQueue.addMessage(wsdlPerspective.getMessage("MSG_ERROR_OPEN_WSDL", wsdlUrl));
            this.handleUnexpectedException(wsdlPerspective, messageQueue, "WSDLException", e);
            return false;
        }
        rootElement.connect((Element)wsdlElement, "relWSDL", "owner");
        wsdlElement.buildModel();
        Node wsdlNode = rootNode.getChildNode(wsdlElement);
        Vector serviceNodes = wsdlNode.getChildNodes();
        int newSelectedNodeId = wsdlNode.getNodeId();
        if (serviceNodes.size() == 1) {
            Node serviceNode = (Node)serviceNodes.elementAt(0);
            Vector bindingNodes = serviceNode.getChildNodes();
            if (bindingNodes.size() == 1) {
                Node bindingNode = (Node)bindingNodes.elementAt(0);
                newSelectedNodeId = bindingNode.getNodeId();
            } else {
                newSelectedNodeId = serviceNode.getNodeId();
            }
        }
        nodeManager.setSelectedNodeId(newSelectedNodeId);
        nodeManager.makeNodeVisible(nodeManager.getNode(newSelectedNodeId));
        this.addToHistory(2, SelectWSDLPropertiesToolAction.getActionLink(newSelectedNodeId, 0, -1, -1, true));
        messageQueue.addMessage(wsdlPerspective.getMessage("MSG_INFO_OPEN_WSDL_SUCCESSFUL", wsdlUrl));
        return true;
    }
}

