/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.figurehandler;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory2;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextFigure;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSTextProvider;
import org.eclipse.jst.pagedesigner.editors.palette.TagImageManager;
import org.eclipse.jst.pagedesigner.figurehandler.BRFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.DefaultFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.HiddenFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.IFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.ImgFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.InputFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.ObjectFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.SelectFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.TextareaFigureHandler;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class FigureFactory {
    private static void createFigureDeep(IFigure parentFigure, Node node) {
        if (node instanceof Element) {
            IFigureHandler handler = FigureFactory.createAndAdapt((Element)node);
            if (handler instanceof HiddenFigureHandler) {
                return;
            }
            CSSFigure figure = new CSSFigure();
            handler.updateFigure((Element)node, figure);
            parentFigure.add((IFigure)figure);
            if (!handler.isWidget()) {
                NodeList children = node.getChildNodes();
                int i = 0;
                int size = children.getLength();
                while (i < size) {
                    FigureFactory.createFigureDeep(figure, children.item(i));
                    ++i;
                }
            }
        } else if (node instanceof Text) {
            final String data = HTMLUtil.compactWhitespaces((Text)node, node.getNodeValue());
            if (data.trim().length() == 0) {
                return;
            }
            CSSTextFigure figure = new CSSTextFigure(new ICSSTextProvider(){

                @Override
                public String getTextData() {
                    return data;
                }

                @Override
                public int[] getSelectedRange() {
                    return null;
                }
            });
            parentFigure.add((IFigure)figure);
        }
    }

    public static IFigure updateDeepFigure(Element ele, Element old, CSSFigure figure) {
        FigureFactory.recursiveDisposeAndUnadapt(old);
        List figureChildren = figure.getChildren();
        int i = figureChildren.size() - 1;
        while (i >= 0) {
            figure.remove((IFigure)figureChildren.get(i));
            --i;
        }
        IFigureHandler handler = FigureFactory.createAndAdapt(ele);
        handler.updateFigure(ele, figure);
        if (!handler.isWidget()) {
            NodeList children = ele.getChildNodes();
            int i2 = 0;
            int size = children.getLength();
            while (i2 < size) {
                FigureFactory.createFigureDeep(figure, children.item(i2));
                ++i2;
            }
        }
        return figure;
    }

    private static void recursiveDisposeAndUnadapt(Element ele) {
        FigureFactory.disposeAndUnadapt(ele);
        NodeList nl = ele.getChildNodes();
        int i = 0;
        int size = nl.getLength();
        while (i < size) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                FigureFactory.recursiveDisposeAndUnadapt((Element)n);
            }
            ++i;
        }
    }

    private static void disposeAndUnadapt(Element ele) {
        IFigureHandler handler = FigureFactory.getHandler(ele);
        if (handler != null) {
            handler.dispose();
            ((IDOMElement)ele).removeAdapter((INodeAdapter)handler);
        }
    }

    private static IFigureHandler getHandler(Element ele) {
        if (ele instanceof IDOMElement) {
            IDOMElement xmlele = (IDOMElement)ele;
            return (IFigureHandler)xmlele.getAdapterFor(IFigureHandler.class);
        }
        return null;
    }

    private static IFigureHandler createAndAdapt(Element ele) {
        IFigureHandler handler = FigureFactory.createFigureHandler(ele);
        if (ele instanceof IDOMElement) {
            ((IDOMElement)ele).addAdapter((INodeAdapter)handler);
        }
        return handler;
    }

    private static IFigureHandler createFigureHandler(Element ele) {
        String tag = ele.getTagName();
        if ("input".equalsIgnoreCase(tag)) {
            return new InputFigureHandler();
        }
        if ("select".equalsIgnoreCase(tag)) {
            return new SelectFigureHandler();
        }
        if ("img".equalsIgnoreCase(tag)) {
            return new ImgFigureHandler();
        }
        if ("object".equalsIgnoreCase(tag)) {
            return new ObjectFigureHandler();
        }
        if ("textarea".equalsIgnoreCase(tag)) {
            return new TextareaFigureHandler();
        }
        if ("br".equalsIgnoreCase(tag)) {
            return new BRFigureHandler();
        }
        if (!HTMLUtil.isVisualHtmlElement(tag)) {
            return new HiddenFigureHandler(FigureFactory.getSharedHTMLImage(ele));
        }
        return new DefaultFigureHandler();
    }

    private static Image getSharedHTMLImage(Element element) {
        IWorkspaceContextResolver wsResolver;
        Image image = null;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory2.INSTANCE.getContext(element);
        if (context != null && (wsResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context)) != null) {
            image = TagImageManager.getInstance().getSmallIconImage((IFile)wsResolver.getResource(), "HTML", element.getLocalName());
        }
        return image != null ? image : JSFUICommonPlugin.getDefault().getImage("PD_Palette_Default.gif");
    }

    private FigureFactory() {
    }
}

