/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xpath.VariableStack;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.xalan.debugger.XalanStyleFrame;
import org.eclipse.wst.xsl.xalan.debugger.XalanVariable;

public class XalanRootStyleFrame
extends XalanStyleFrame {
    private static final Log log = LogFactory.getLog(XalanRootStyleFrame.class);
    private Map variables;
    private ArrayList globals;

    public XalanRootStyleFrame(TracerEvent event) {
        super(null, event);
        this.fillGlobals(event);
    }

    @Override
    protected List getGlobals() {
        return this.globals;
    }

    private void fillGlobals(TracerEvent event) {
        VariableStack vs = event.m_processor.getXPathContext().getVarStack();
        StylesheetRoot sr = event.m_styleNode.getStylesheetRoot();
        Vector vars = sr.getVariablesAndParamsComposed();
        this.variables = new HashMap(vars.size());
        this.globals = new ArrayList(vars.size());
        int i = vars.size();
        while (--i >= 0) {
            ElemVariable variable = (ElemVariable)vars.elementAt(i);
            XalanVariable xvar = new XalanVariable(this, vs, "G", i, variable);
            this.addVariable(xvar);
            this.globals.add(xvar);
        }
    }

    public Variable getVariable(int id) {
        return (Variable)this.variables.get(new Integer(id));
    }

    public void addVariable(XalanVariable xvar) {
        log.debug((Object)("Adding variable id=" + xvar.getId()));
        this.variables.put(new Integer(xvar.getId()), xvar);
    }
}

