/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.libval;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.internal.libval.InternalLibraryValidatorManager;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

class LibraryValidatorConfig {
    private final InternalLibraryValidatorManager manager;
    private final String id;
    private final String className;
    private String pluginID;
    private Expression enablementExpression;
    private LibraryValidator libraryValidator;
    private static final String CONFIG_ENABLEMENT_EXPRESSION_VARIABLE = "config";
    private static final String LIBRARY_PROVIDER_ENABLEMENT_EXPRESSION_VARIABLE = "libraryProvider";
    static final Transformer<LibraryValidatorConfig, LibraryValidator> LIBRARY_VALIDATOR_TRANSFORMER = new LibraryValidatorTransformer();

    LibraryValidatorConfig(InternalLibraryValidatorManager manager, String id, String className) {
        this.manager = manager;
        this.id = id;
        this.className = className;
    }

    InternalLibraryValidatorManager getManager() {
        return this.manager;
    }

    String getID() {
        return this.id;
    }

    String getClassName() {
        return this.className;
    }

    String getPluginID() {
        return this.pluginID;
    }

    void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    Expression getEnablementExpression() {
        return this.enablementExpression;
    }

    void setEnablementExpression(Expression enablementExpression) {
        this.enablementExpression = enablementExpression;
    }

    boolean isEnabled(JptLibraryProviderInstallOperationConfig installConfig) {
        return this.enablementExpression == null || this.isEnabled_(installConfig);
    }

    private boolean isEnabled_(JptLibraryProviderInstallOperationConfig installConfig) {
        EvaluationContext evalContext = new EvaluationContext(null, (Object)installConfig);
        evalContext.setAllowPluginActivation(true);
        evalContext.addVariable(CONFIG_ENABLEMENT_EXPRESSION_VARIABLE, (Object)installConfig);
        evalContext.addVariable(LIBRARY_PROVIDER_ENABLEMENT_EXPRESSION_VARIABLE, (Object)installConfig.getLibraryProvider());
        try {
            return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
        }
        catch (CoreException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    synchronized LibraryValidator getLibraryValidator() {
        if (this.libraryValidator == null) {
            this.libraryValidator = this.buildLibraryValidator();
        }
        return this.libraryValidator;
    }

    private LibraryValidator buildLibraryValidator() {
        return ExtensionPointTools.instantiate(this.pluginID, this.manager.getExtensionPointName(), this.className, LibraryValidator.class);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.className);
    }

    static class IsEnabled
    extends CriterionPredicate<LibraryValidatorConfig, JptLibraryProviderInstallOperationConfig> {
        IsEnabled(JptLibraryProviderInstallOperationConfig installConfig) {
            super((Object)installConfig);
        }

        public boolean evaluate(LibraryValidatorConfig config) {
            return config.isEnabled((JptLibraryProviderInstallOperationConfig)this.criterion);
        }
    }

    static class LibraryValidatorTransformer
    extends TransformerAdapter<LibraryValidatorConfig, LibraryValidator> {
        LibraryValidatorTransformer() {
        }

        public LibraryValidator transform(LibraryValidatorConfig config) {
            return config.getLibraryValidator();
        }
    }
}

