/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.handlers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.refactor.handlers.RefactoringHandler;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeAnonymousTypeGlobalCommand;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Node;

public class MakeAnonymousTypeGobalHandler
extends RefactoringHandler {
    private String parentName;
    private boolean isComplexType = true;

    public Object doExecute(ISelection selection, XSDSchema schema) {
        if (selection != null) {
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof XSDBaseAdapter) {
                selectedObject = ((XSDBaseAdapter)selectedObject).getTarget();
            }
            XSDConcreteComponent concreteComp = null;
            if (selectedObject instanceof Node) {
                Node node = (Node)selectedObject;
                concreteComp = schema.getCorrespondingComponent(node);
            } else if (selectedObject instanceof XSDConcreteComponent) {
                concreteComp = (XSDConcreteComponent)selectedObject;
            }
            if (concreteComp != null && concreteComp instanceof XSDComplexTypeDefinition) {
                this.isComplexType = true;
                XSDComplexTypeDefinition typeDef = (XSDComplexTypeDefinition)concreteComp;
                XSDConcreteComponent parent = typeDef.getContainer();
                if (parent instanceof XSDElementDeclaration) {
                    this.parentName = ((XSDElementDeclaration)parent).getName();
                    this.run(selection, schema, (XSDTypeDefinition)typeDef);
                } else if (concreteComp instanceof XSDSimpleTypeDefinition) {
                    this.isComplexType = false;
                    XSDSimpleTypeDefinition simpleTypeDef = (XSDSimpleTypeDefinition)concreteComp;
                    XSDConcreteComponent parentComp = simpleTypeDef.getContainer();
                    if (parentComp instanceof XSDElementDeclaration) {
                        this.parentName = ((XSDElementDeclaration)parent).getName();
                    } else if (parent instanceof XSDAttributeDeclaration) {
                        this.parentName = ((XSDAttributeDeclaration)parent).getName();
                    }
                    this.run(selection, schema, (XSDTypeDefinition)simpleTypeDef);
                }
            }
        }
        return null;
    }

    private String getNewDefaultName() {
        if (this.parentName != null && !"".equals(this.parentName)) {
            if (this.isComplexType) {
                return String.valueOf(this.parentName) + "ComplexType";
            }
            return String.valueOf(this.parentName) + "SimpleType";
        }
        if (this.isComplexType) {
            return "NewComplexType";
        }
        return "NewSimpleType";
    }

    public void run(ISelection selection, XSDSchema schema, XSDTypeDefinition selectedComponent) {
        if (selectedComponent == null) {
            return;
        }
        if (selectedComponent.getSchema() == null) {
            schema.updateElement(true);
        }
        DocumentImpl doc = (DocumentImpl)selectedComponent.getElement().getOwnerDocument();
        doc.getModel().beginRecording((Object)this, RefactoringWizardMessages.MakeAnonymousTypeGlobalAction_text);
        MakeAnonymousTypeGlobalCommand command = new MakeAnonymousTypeGlobalCommand((XSDConcreteComponent)selectedComponent, this.getNewDefaultName());
        command.run();
        doc.getModel().endRecording((Object)this);
    }
}

