/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.modulecore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.IJavaComponentDiscerner;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JEEManifestDiscerner
implements IJavaComponentDiscerner {
    public IProject[] findParentProjects(IProject child) {
        return EarUtilities.getReferencingEARProjects(child);
    }

    public IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject) {
        if (EarUtilities.isEARProject(parentProject)) {
            ArrayList<IVirtualReference> allPossible = this.findAllPossibleEntries(parentProject, childProject);
            IVirtualReference[] alreadyReferenced = this.findCurrentManifestEntries(parentProject, childProject, allPossible);
            allPossible.removeAll(Arrays.asList(alreadyReferenced));
            return allPossible.toArray(new IVirtualReference[allPossible.size()]);
        }
        return new IVirtualReference[0];
    }

    public IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject, IVirtualReference[] currentEntries) {
        if (EarUtilities.isEARProject(parentProject)) {
            ArrayList<IVirtualReference> allPossible = this.findAllPossibleEntries(parentProject, childProject);
            allPossible.removeAll(Arrays.asList(currentEntries));
            return allPossible.toArray(new IVirtualReference[allPossible.size()]);
        }
        return new IVirtualReference[0];
    }

    protected ArrayList<IVirtualReference> findAllPossibleEntries(IProject parentProject, IProject childProject) {
        IVirtualComponent ear = ComponentCore.createComponent((IProject)parentProject);
        IVirtualReference[] hardRefs = ear.getReferences();
        IVirtualReference[] actual_tmp = this.trimEarHardRefs(ear, childProject, hardRefs);
        IVirtualReference[] actual_clean = this.cleanHardRefs(actual_tmp, childProject, hardRefs);
        ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        refs.addAll(Arrays.asList(actual_clean));
        return refs;
    }

    private IVirtualReference[] trimEarHardRefs(IVirtualComponent ear, IProject childProject, IVirtualReference[] hardRefs) {
        String earLibDir = EarUtilities.getEARLibDir(ear);
        IPath earLibDirPath = null;
        if (earLibDir != null) {
            earLibDirPath = new Path(earLibDir).makeRelative();
        }
        ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < hardRefs.length) {
            if (!(!hardRefs[i].getReferencedComponent().isBinary() && hardRefs[i].getDependencyType() != 1 && hardRefs[i].getReferencedComponent().getProject().equals((Object)childProject) || !hardRefs[i].getArchiveName().endsWith("jar") || earLibDirPath != null && !earLibDirPath.isEmpty() && hardRefs[i].getRuntimePath().makeRelative().equals((Object)earLibDirPath))) {
                refs.add(hardRefs[i]);
            }
            ++i;
        }
        return refs.toArray(new IVirtualReference[refs.size()]);
    }

    private IVirtualReference[] cleanHardRefs(IVirtualReference[] original, IProject childProject, IVirtualReference[] hardRefs) {
        IVirtualReference childProjectVirtualRef = null;
        int i = 0;
        while (i < hardRefs.length) {
            if (hardRefs[i].getReferencedComponent().getProject().equals((Object)childProject)) {
                childProjectVirtualRef = hardRefs[i];
                break;
            }
            ++i;
        }
        IVirtualReference[] newRefs = new IVirtualReference[original.length];
        int i2 = 0;
        while (i2 < newRefs.length) {
            newRefs[i2] = ComponentCore.createReference((IVirtualComponent)original[i2].getEnclosingComponent(), (IVirtualComponent)original[i2].getReferencedComponent(), (IPath)JEEManifestDiscerner.calculateManifestRelativeRuntimePath(childProjectVirtualRef, original[i2]));
            newRefs[i2].setDependencyType(original[i2].getDependencyType());
            newRefs[i2].setArchiveName(new Path(original[i2].getArchiveName()).lastSegment());
            ++i2;
        }
        return newRefs;
    }

    public static IPath calculateManifestRelativeRuntimePath(IVirtualReference childProjectVirtualRef, IVirtualReference manifestEntryReference) {
        IPath manifestEntryPath = manifestEntryReference.getRuntimePath();
        if (childProjectVirtualRef == null || childProjectVirtualRef.getRuntimePath().equals((Object)"/")) {
            return manifestEntryPath.makeRelative();
        }
        IPath childProjectRuntimePath = childProjectVirtualRef.getRuntimePath();
        if (childProjectRuntimePath.equals((Object)manifestEntryPath)) {
            return new Path("");
        }
        String[] childProjectFolders = childProjectRuntimePath.segments();
        String[] manifestEntryFolders = manifestEntryPath.segments();
        int commonFolderCount = 0;
        int i = 0;
        while (i < childProjectFolders.length) {
            if (i >= manifestEntryFolders.length || !childProjectFolders[i].equals(manifestEntryFolders[i])) break;
            ++commonFolderCount;
            ++i;
        }
        String resultString = "";
        int i2 = 0;
        while (i2 < childProjectFolders.length - commonFolderCount) {
            resultString = String.valueOf(resultString) + "../";
            ++i2;
        }
        return new Path(resultString).append(manifestEntryPath.removeFirstSegments(commonFolderCount));
    }

    public IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject) {
        return this.findCurrentManifestEntries(parentProject, childProject, this.findAllPossibleEntries(parentProject, childProject));
    }

    protected IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject, ArrayList<IVirtualReference> allPossibleEntries) {
        ArrayList<IVirtualReference> currentEntries = new ArrayList<IVirtualReference>();
        IFile manifestFile = this.getManifestFile(childProject);
        if (manifestFile != null) {
            ArchiveManifest manifest = ManifestUtilities.getManifest((IFile)manifestFile);
            List<String> entries = Arrays.asList(manifest.getClassPathTokenized());
            for (IVirtualReference currentI : allPossibleEntries) {
                String currentEntry = currentI.getRuntimePath().append(new Path(currentI.getArchiveName()).lastSegment()).toString();
                if (!entries.contains(currentEntry)) continue;
                currentEntries.add(currentI);
            }
        }
        return currentEntries.toArray(new IVirtualReference[currentEntries.size()]);
    }

    protected IFile getManifestFile(IProject child) {
        IVirtualComponent root = ComponentCore.createComponent((IProject)child);
        IVirtualFolder rootFolder = root.getRootFolder();
        IVirtualFile vf = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (vf.exists()) {
            return vf.getUnderlyingFile();
        }
        return null;
    }
}

