/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0, which accompanies this distribution
 * and is available at https://www.eclipse.org/legal/epl-2.0/.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.StatefulCommandContext;

/**
 * @see AbstractQueueingCommandContext
 */
public class QueueingCommandContext
	extends AbstractQueueingCommandContext<StatefulCommandContext>
{
	public QueueingCommandContext() {
		this(DefaultCommandContext.instance());
	}

	public QueueingCommandContext(CommandContext commandContext) {
		this(new SimpleStatefulCommandContext(commandContext));
	}

	public QueueingCommandContext(StatefulCommandContext commandContext) {
		super(commandContext);
	}
}
