/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.operation;

import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.testutils.IWaitCondition;
import org.eclipse.jst.ws.jaxws.testutils.assertions.Assertions;
import org.eclipse.jst.ws.jaxws.testutils.assertions.ConditionCheckException;
import org.eclipse.jst.ws.jaxws.utils.operation.OperationInJobRunner;

public class OperationInJobRunnerTest
extends TestCase {
    private static final String TEST_JOB_NAME = "OperationInJobRunnerTestJob" + System.currentTimeMillis();
    private OperationInJobRunner opRunner;

    protected void setUp() throws Exception {
        super.setUp();
        this.opRunner = new OperationInJobRunner(TEST_JOB_NAME, null);
    }

    public void testOperationExecutedSuccessfully() {
        this.runOperation(new TestOperation(), 0);
    }

    public void testOperationInterrupted() {
        this.runOperation(this.interruptedOperation(), 8);
    }

    public void testOperationFailed() {
        this.runOperation(this.failingOperation(), 4);
    }

    private void runOperation(TestOperation op, int expectedExecutionStatusSeverity) {
        IStatus status = this.runOperation(op);
        this.assertOperationExecuted(op);
        OperationInJobRunnerTest.assertEquals((String)"Unexpected job status severity", (int)expectedExecutionStatusSeverity, (int)status.getSeverity());
    }

    private TestOperation interruptedOperation() {
        return new TestOperation(this){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                super.run(monitor);
                throw new InterruptedException();
            }
        };
    }

    private TestOperation failingOperation() {
        return new TestOperation(this){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                super.run(monitor);
                throw new InvocationTargetException(new Exception());
            }
        };
    }

    private void assertOperationExecuted(TestOperation op) {
        OperationInJobRunnerTest.assertTrue((String)"Operation not executed", (boolean)op.isExecuted);
    }

    private IStatus runOperation(IRunnableWithProgress runnable) {
        IStatus[] jobStatus = new IStatus[1];
        TestJobChangeListener jobListener = new TestJobChangeListener(jobStatus);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)jobListener);
        try {
            this.opRunner.run(runnable);
            this.waitForStatus(jobStatus);
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)jobListener);
        }
        return jobStatus[0];
    }

    private void waitForStatus(final IStatus[] statusHolder) {
        Assertions.waitAssert((IWaitCondition)new IWaitCondition(){

            public boolean checkCondition() throws ConditionCheckException {
                return statusHolder[0] != null;
            }
        }, (String)"test job did not finish");
    }

    private class TestJobChangeListener
    extends JobChangeAdapter {
        private IStatus[] statusHolder;

        public TestJobChangeListener(IStatus[] statusHolder) {
            this.statusHolder = statusHolder;
        }

        public void done(IJobChangeEvent event) {
            if (this.isTheTestJob(event)) {
                this.statusHolder[0] = event.getResult();
            }
        }

        private boolean isTheTestJob(IJobChangeEvent event) {
            return event.getJob().getName() == TEST_JOB_NAME;
        }
    }

    private class TestOperation
    implements IRunnableWithProgress {
        public boolean isExecuted = false;

        private TestOperation() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.isExecuted = true;
        }

        /* synthetic */ TestOperation(TestOperation testOperation, TestOperation testOperation2) {
            this();
        }
    }
}

