/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xsl.jaxp.launching.IDebugger;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInvoker;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.internal.FeaturePreferences;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;
import org.eclipse.wst.xsl.jaxp.launching.internal.OutputPropertyPreferences;
import org.eclipse.wst.xsl.jaxp.launching.internal.ProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.internal.ProcessorPreferences;
import org.eclipse.wst.xsl.jaxp.launching.internal.registry.DebuggerRegistry;
import org.eclipse.wst.xsl.jaxp.launching.internal.registry.InvokerRegistry;
import org.eclipse.wst.xsl.jaxp.launching.internal.registry.ProcessorRegistry;
import org.eclipse.wst.xsl.jaxp.launching.internal.registry.ProcessorTypeRegistry;

public class JAXPRuntime {
    public static final String PREF_PROCESSOR_XML = "PREF_PROCESSOR_XML";
    public static final String PREF_FEATURE_XML = "PREF_FEATURE_XML";
    public static final String PREF_OUTPUT_PROPERTIES_XML = "PREF_OUTPUT_PROPERTIES_XML";
    public static final String JRE_DEFAULT_PROCESSOR_ID = "org.eclipse.wst.xsl.launching.jre.default";
    public static final String JRE_DEFAULT_PROCESSOR_TYPE_ID = "org.eclipse.wst.xsl.launching.processorType.jreDefault";
    private static byte[] NEXT_ID_LOCK = new byte[0];
    private static byte[] REGISTRY_LOCK = new byte[0];
    private static int lastStandinID;
    private static ProcessorTypeRegistry processorTypeRegistry;
    private static ProcessorRegistry processorRegistry;
    private static InvokerRegistry invokerRegistry;
    private static DebuggerRegistry debuggerRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessorTypeRegistry getProcessorTypeRegistry() {
        byte[] byArray = REGISTRY_LOCK;
        synchronized (REGISTRY_LOCK) {
            if (processorTypeRegistry == null) {
                processorTypeRegistry = new ProcessorTypeRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processorTypeRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessorRegistry getProcessorRegistry() {
        byte[] byArray = REGISTRY_LOCK;
        synchronized (REGISTRY_LOCK) {
            if (processorRegistry == null) {
                processorRegistry = new ProcessorRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processorRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InvokerRegistry getInvokerRegistry() {
        byte[] byArray = REGISTRY_LOCK;
        synchronized (REGISTRY_LOCK) {
            if (invokerRegistry == null) {
                invokerRegistry = new InvokerRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return invokerRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DebuggerRegistry getDebuggerRegistry() {
        byte[] byArray = REGISTRY_LOCK;
        synchronized (REGISTRY_LOCK) {
            if (debuggerRegistry == null) {
                debuggerRegistry = new DebuggerRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return debuggerRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePreferences() {
        JAXPLaunchingPlugin.getDefault().savePluginPreferences();
        byte[] byArray = REGISTRY_LOCK;
        synchronized (REGISTRY_LOCK) {
            processorRegistry = null;
            processorTypeRegistry = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUniqueProcessorId(IProcessorType type) {
        IProcessorInstall[] installs = JAXPRuntime.getProcessors(type.getId());
        String id = null;
        byte[] byArray = NEXT_ID_LOCK;
        synchronized (NEXT_ID_LOCK) {
            while (JAXPRuntime.isTaken(id = String.valueOf(++lastStandinID), installs)) {
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    public static IProcessorJar createProcessorJar(IPath path) {
        return new ProcessorJar(path);
    }

    private static boolean isTaken(String id, IProcessorInstall[] installs) {
        IProcessorInstall[] iProcessorInstallArray = installs;
        int n = installs.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorInstall install = iProcessorInstallArray[n2];
            if (install.getId().equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IDebugger[] getDebuggers() {
        return JAXPRuntime.getDebuggerRegistry().getDebuggers();
    }

    public static IDebugger getDebugger(String id) {
        return JAXPRuntime.getDebuggerRegistry().getDebugger(id);
    }

    public static IProcessorInstall[] getProcessors() {
        return JAXPRuntime.getProcessorRegistry().getProcessors();
    }

    public static IProcessorInstall[] getProcessors(String typeId) {
        return JAXPRuntime.getProcessorRegistry().getProcessors(typeId);
    }

    public static IProcessorInstall getProcessor(String processorId) {
        IProcessorInstall[] processors;
        IProcessorInstall[] iProcessorInstallArray = processors = JAXPRuntime.getProcessors();
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorInstall install = iProcessorInstallArray[n2];
            if (install.getId().equals(processorId)) {
                return install;
            }
            ++n2;
        }
        return null;
    }

    public static IProcessorInstall getDefaultProcessor() {
        return JAXPRuntime.getProcessorRegistry().getDefaultProcessor();
    }

    public static IProcessorInstall getJREDefaultProcessor() {
        return JAXPRuntime.getProcessorRegistry().getJREDefaultProcessor();
    }

    public static IProcessorType[] getProcessorTypes() {
        return JAXPRuntime.getProcessorTypeRegistry().getProcessorTypes();
    }

    public static IProcessorType[] getProcessorTypesExclJREDefault() {
        return JAXPRuntime.getProcessorTypeRegistry().getProcessorTypesExclJREDefault();
    }

    public static IProcessorType getProcessorType(String id) {
        return JAXPRuntime.getProcessorTypeRegistry().getProcessorType(id);
    }

    public static IProcessorInvoker getProcessorInvoker(String invokerId) {
        return JAXPRuntime.getInvokerRegistry().getProcessorInvoker(invokerId);
    }

    public static IProcessorInvoker[] getProcessorInvokers() {
        return JAXPRuntime.getInvokerRegistry().getProcessorInvokers();
    }

    private static Preferences getPreferences() {
        return JAXPLaunchingPlugin.getDefault().getPluginPreferences();
    }

    public static void saveFeaturePreferences(Map<IProcessorType, Map<String, String>> typeFeatures, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask(Messages.XSLTRuntime_5, 100);
            FeaturePreferences prefs = new FeaturePreferences();
            HashMap<String, Map<String, String>> typeIdFeatures = new HashMap<String, Map<String, String>>(typeFeatures.size());
            for (IProcessorType type : typeFeatures.keySet()) {
                Map<String, String> values = typeFeatures.get(type);
                typeIdFeatures.put(type.getId(), values);
            }
            prefs.setTypeFeatures(typeIdFeatures);
            String xml = prefs.getAsXML();
            monitor.worked(40);
            if (monitor.isCanceled()) {
                return;
            }
            JAXPRuntime.getPreferences().setValue(PREF_FEATURE_XML, xml);
            monitor.worked(30);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                JAXPRuntime.savePreferences();
                monitor.worked(30);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", Messages.XSLTRuntime_6, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void saveOutputPropertyPreferences(Map<IProcessorType, Map<String, String>> typeProperties, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask(Messages.XSLTRuntime_7, 100);
            OutputPropertyPreferences prefs = new OutputPropertyPreferences();
            for (IProcessorType type : typeProperties.keySet()) {
                prefs.setOutputPropertyValues(type.getId(), typeProperties.get(type));
            }
            String xml = prefs.getAsXML();
            monitor.worked(40);
            if (monitor.isCanceled()) {
                return;
            }
            JAXPRuntime.getPreferences().setValue(PREF_OUTPUT_PROPERTIES_XML, xml);
            monitor.worked(30);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                JAXPRuntime.savePreferences();
                monitor.worked(30);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", Messages.XSLTRuntime_8, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void saveProcessorPreferences(IProcessorInstall[] installs, IProcessorInstall defaultInstall, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask(Messages.XSLTRuntime_9, 100);
            ProcessorPreferences prefs = new ProcessorPreferences();
            if (defaultInstall != null) {
                prefs.setDefaultProcessorId(defaultInstall.getId());
            }
            prefs.setProcessors(new ArrayList<IProcessorInstall>(Arrays.asList(installs)));
            String xml = prefs.getAsXML();
            monitor.worked(40);
            if (monitor.isCanceled()) {
                return;
            }
            JAXPRuntime.getPreferences().setValue(PREF_PROCESSOR_XML, xml);
            monitor.worked(30);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                JAXPRuntime.savePreferences();
                monitor.worked(30);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", Messages.XSLTRuntime_10, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public static Map<String, String> createDefaultOutputProperties(String typeId) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (JRE_DEFAULT_PROCESSOR_TYPE_ID.equals(typeId)) {
            props.put("indent", "yes");
        } else if ("org.eclipse.wst.xsl.xalan.processorType".equals(typeId)) {
            props.put("indent", "yes");
            props.put("{http://xml.apache.org/xslt}indent-amount", "4");
        } else if ("org.eclipse.wst.xsl.saxon.processorType".equals(typeId)) {
            props.put("indent", "yes");
            props.put("{http://saxon.sf.net/}indent-spaces", "4");
        } else if ("org.eclipse.wst.xsl.saxon_1_0.processorType".equals(typeId)) {
            props.put("indent", "yes");
            props.put("{http://saxon.sf.net/}indent-spaces", "4");
        }
        return props;
    }
}

