/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.common.frameworks.internal.AbstractRegistryDescriptor;

public class EditModelResource
extends AbstractRegistryDescriptor
implements Comparable {
    public static final String EDIT_MODEL_URI_ATTR = "URI";
    public static final String AUTO_LOAD_ATTR = "autoload";
    public static final String EDIT_MODEL_RESOURCE_ELEMENT = "editModelResource";
    private static int loadOrderCounter = 1;
    private URI uri;
    private boolean autoload = false;
    private boolean isCore = true;
    private String extensionID;
    private int loadOrder;

    public EditModelResource(IConfigurationElement element) {
        super(element);
        String strLoad;
        String strUri = element.getAttribute(EDIT_MODEL_URI_ATTR);
        if (strUri != null) {
            this.uri = URI.createURI((String)strUri);
        }
        if ((strLoad = element.getAttribute(AUTO_LOAD_ATTR)) != null) {
            this.autoload = Boolean.valueOf(strLoad);
        }
        this.loadOrder = loadOrderCounter++;
    }

    public EditModelResource(IConfigurationElement element, String extensionID) {
        this(element);
        this.extensionID = extensionID;
        this.isCore = false;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isAutoLoad() {
        return this.autoload;
    }

    public String getID() {
        return this.extensionID;
    }

    public int getPriority() {
        if (this.isCore) {
            return 0;
        }
        return super.getPriority();
    }

    public boolean isCore() {
        return this.isCore;
    }

    public int compareTo(Object o) {
        if (!(o instanceof EditModelResource)) {
            return 1;
        }
        EditModelResource res = (EditModelResource)o;
        int value = this.getPriority() - res.getPriority();
        if (value == 0) {
            return this.loadOrder - res.loadOrder;
        }
        return value;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }
}

