/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.swt.bindings.AbstractComboSelectionBinding;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;

final class DropDownListBoxSelectionBinding<E>
extends AbstractComboSelectionBinding<E, DropDownListBox> {
    private E selectedItem;

    DropDownListBoxSelectionBinding(ArrayList<E> list, ModifiablePropertyValueModel<E> selectedItemModel, DropDownListBox dropdownListBox) {
        super(list, selectedItemModel, dropdownListBox);
        this.selectedItem = this.valueModel.getValue();
    }

    @Override
    public void listChanged() {
        this.setComboSelection();
    }

    @Override
    void valueChanged_(E item) {
        this.selectedItem = item;
        this.setComboSelection();
    }

    private void setComboSelection() {
        int oldIndex = ((DropDownListBox)this.combo).getSelectionIndex();
        int newIndex = this.indexOf(this.selectedItem);
        if (newIndex == -1) {
            if (oldIndex != -1) {
                ((DropDownListBox)this.combo).deselectAll();
            }
        } else if (newIndex != oldIndex) {
            if (oldIndex != -1) {
                ((DropDownListBox)this.combo).deselect(oldIndex);
            }
            ((DropDownListBox)this.combo).select(newIndex);
        }
    }

    private int indexOf(E item) {
        int i = 0;
        for (Object each : this.list) {
            if (ObjectTools.equals(each, item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.selectedItem = null;
    }

    static interface DropDownListBox
    extends AbstractComboSelectionBinding.ComboAdapter {
        public void select(int var1);

        public void deselect(int var1);

        public void deselectAll();
    }
}

