/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.util.ConcurrentModificationException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.jface.ItemContentProvider;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

abstract class ModelItemContentProvider<M extends ItemContentProvider.Manager>
implements ItemContentProvider {
    final Object item;
    private final CollectionValueModel<?> childrenModel;
    private final CollectionChangeListener childrenListener;
    Object[] children;
    final M manager;
    static final Iterable<?> EMPTY_ITERABLE = EmptyIterable.instance();

    ModelItemContentProvider(Object item, CollectionValueModel<?> childrenModel, M manager) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.item = item;
        if (childrenModel == null) {
            throw new NullPointerException();
        }
        this.childrenModel = childrenModel;
        if (manager == null) {
            throw new NullPointerException();
        }
        this.manager = manager;
        this.childrenListener = this.buildChildrenListener();
        this.childrenModel.addCollectionChangeListener("values", this.childrenListener);
        this.children = this.buildChildren();
    }

    Object[] getChildren() {
        return this.children;
    }

    private CollectionChangeListener buildChildrenListener() {
        return SWTListenerTools.wrap(this.buildChildrenListener_(), (Viewer)this.manager.getViewer());
    }

    private CollectionChangeListener buildChildrenListener_() {
        return new ChildrenListener();
    }

    void childrenAdded(Iterable<?> addedChildren) {
        if (this.isAlive()) {
            this.childrenAdded_(addedChildren);
        }
    }

    private void childrenAdded_(Iterable<?> addedChildren) {
        this.children = ArrayTools.addAll((Object[])this.children, addedChildren);
        this.notifyManager(addedChildren, EMPTY_ITERABLE);
    }

    void childrenRemoved(Iterable<?> removedChildren) {
        if (this.isAlive()) {
            this.childrenRemoved_(removedChildren);
        }
    }

    private void childrenRemoved_(Iterable<?> removedChildren) {
        this.children = ArrayTools.removeAll((Object[])this.children, removedChildren);
        this.notifyManager(EMPTY_ITERABLE, removedChildren);
    }

    void childrenChanged() {
        if (this.isAlive()) {
            this.childrenChanged_();
        }
    }

    private void childrenChanged_() {
        Object[] old = this.children;
        this.children = this.buildChildren();
        Iterable addedChildren = ArrayTools.iterable((Object[])ArrayTools.removeAll((Object[])this.children, (Object[])old));
        Iterable removedChildren = ArrayTools.iterable((Object[])ArrayTools.removeAll((Object[])old, (Object[])this.children));
        this.notifyManager(addedChildren, removedChildren);
    }

    void childrenCleared() {
        if (this.isAlive()) {
            this.childrenCleared_();
        }
    }

    private void childrenCleared_() {
        Object[] old = this.children;
        this.children = ObjectTools.EMPTY_OBJECT_ARRAY;
        if (old.length != 0) {
            this.notifyManager(EMPTY_ITERABLE, ArrayTools.iterable((Object[])old));
        }
    }

    abstract void notifyManager(Iterable<?> var1, Iterable<?> var2);

    private Object[] buildChildren() {
        while (true) {
            try {
                return ArrayTools.array(this.childrenModel);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void dispose() {
        this.childrenModel.removeCollectionChangeListener("values", this.childrenListener);
        this.children = null;
    }

    private boolean isAlive() {
        return this.children != null;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.item);
    }

    class ChildrenListener
    extends CollectionChangeAdapter {
        ChildrenListener() {
        }

        public void itemsAdded(CollectionAddEvent event) {
            ModelItemContentProvider.this.childrenAdded(event.getItems());
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            ModelItemContentProvider.this.childrenRemoved(event.getItems());
        }

        public void collectionChanged(CollectionChangeEvent event) {
            ModelItemContentProvider.this.childrenChanged();
        }

        public void collectionCleared(CollectionClearEvent event) {
            ModelItemContentProvider.this.childrenCleared();
        }
    }
}

