/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.action;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowPropertyViewAction
extends SelectionAction {
    private static final Logger log = EditorPlugin.getLogger(ShowPropertyViewAction.class);
    public static final String SHOW_PROPERTY_VIEW = "org.eclipse.jst.jsf.facesconfig.ui.pageflow.action.ShowPropertyViewAction";

    public ShowPropertyViewAction(IWorkbenchPart part) {
        super(part);
        this.setText(PageflowMessages.Pageflow_Action_ShowPropertyView_Label);
        this.setId(SHOW_PROPERTY_VIEW);
        this.setToolTipText(PageflowMessages.Pageflow_Action_ShowPropertyView_ToolTip);
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        List parts = this.getSelectedObjects();
        int i = 0;
        while (i < parts.size()) {
            Object o = parts.get(i);
            if (!(o instanceof EditPart)) {
                return false;
            }
            EditPart part = (EditPart)o;
            if (!(part.getModel() instanceof PageflowElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        IWorkbenchWindow dw;
        IWorkbenchPage page;
        EditPart part;
        List editparts = this.getSelectedObjects();
        if (editparts.size() > 0 && (part = (EditPart)editparts.get(0)).getModel() instanceof PageflowElement && (page = (dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            try {
                page.showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                log.error("Pageflow.PageflowEditor.Error.canNotShowPropertyView", (Throwable)e);
            }
        }
    }
}

