/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.common.UnresolvedCompilationError;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringEvaluationException;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringParser;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InitparserTreeMessages;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalExpressionProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.VariableReference;

public class ExpressionProcesser {
    private List expressionStack = new ArrayList(10);
    private List expressionTypeStack = new ArrayList(10);
    private ArrayList expressionProxies;
    private boolean errorOccurred = false;
    private boolean novalueException = false;
    private Throwable exception = null;
    protected Object ignoreExpression = null;
    private List saveStates;
    protected final boolean traceOn;
    private final long thresholdTime;
    private long startExpressionStepTime;
    private long startExpressionTime;
    private long lastExpressionEndTime;
    protected final String traceHeader;
    private int indent = 0;
    private static int TRACE_COUNTER;
    private static final Object IFELSE_IGNORE;
    private int ifElseNesting = 0;
    private int ifElseIgnoreNestCount = 0;
    private boolean ifElseSkipTruePart;
    protected static final int BOOLEAN = 0;
    protected static final int BYTE = 1;
    protected static final int SHORT = 2;
    protected static final int CHAR = 3;
    protected static final int INT = 4;
    protected static final int LONG = 5;
    protected static final int FLOAT = 6;
    protected static final int DOUBLE = 7;
    private static final Object INFIX_IGNORE;
    private int infixNesting = 0;
    private int infixIgnoreNestCount = 0;
    private static final Object CONDITIONAL_IGNORE;
    private int conditionalNesting = 0;
    private int conditionalIgnoreNestCount = 0;
    private boolean skipTruePart;
    private static final Object BLOCK_IGNORE;
    private int[] blocks;
    private int topBlock = -1;
    private int breakBlock = -1;
    private static final Object TRY_THROW_IGNORE;
    private static final Object TRY_FINAL_IGNORE;
    private int[] trys;
    private Throwable[] trysInCatch;
    private int topTry = -1;
    private int breakTry = -1;
    private Throwable catchThrowable;
    private static final Throwable FINAL_CATCH;
    private int[] subexpressions;
    private int[] subexpressionStackPos;
    private int topSubexpression = -1;

    static {
        IFELSE_IGNORE = "IF/ELSE IGNORE";
        INFIX_IGNORE = "INFIX IGNORE";
        CONDITIONAL_IGNORE = "CONDITIONAL IGNORE";
        BLOCK_IGNORE = "BLOCK IGNORE";
        TRY_THROW_IGNORE = "TRY THROW IGNORE";
        TRY_FINAL_IGNORE = "TRY FINAL IGNORE";
        FINAL_CATCH = new RuntimeException();
    }

    public final void processException(Throwable e) {
        this.novalueException = false;
        while (e.getCause() != null) {
            e = e.getCause();
        }
        if (this.traceOn) {
            System.out.println();
            System.out.print("***** >>>\tException: ");
            System.out.println(e);
        }
        this.throwException(e);
    }

    protected final void processSyntaxException(Throwable e) {
        this.errorOccurred = true;
        this.novalueException = false;
        this.exception = e;
    }

    protected final void processSyntaxException(NoExpressionValueException e) {
        if (this.traceOn) {
            System.out.println();
            this.printTrace("Expression has no value", false);
        }
        try {
            this.errorOccurred = true;
            this.novalueException = true;
            this.exception = e;
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public boolean noErrors() {
        return !this.errorOccurred;
    }

    public boolean isNoExpressionValue() {
        return this.novalueException;
    }

    public Throwable getErrorThrowable() {
        return this.exception;
    }

    protected final void pushExpressionValue(Object o, Class type) {
        this.expressionStack.add(o);
        this.expressionTypeStack.add(type);
    }

    protected final Object popExpression() throws NoExpressionValueException {
        return this.popExpression(true);
    }

    protected final Object popExpression(boolean deReference) throws NoExpressionValueException {
        try {
            if (this.topSubexpression != -1 && this.expressionStack.size() == this.subexpressionStackPos[this.topSubexpression]) {
                throw new NoExpressionValueException();
            }
            Object result = this.expressionStack.remove(this.expressionStack.size() - 1);
            if (deReference && result instanceof VariableReference) {
                result = ((VariableReference)result).dereference();
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final Object getExpression(int fromTop) throws NoExpressionValueException {
        try {
            if (this.topSubexpression != -1 && this.expressionStack.size() - fromTop < this.subexpressionStackPos[this.topSubexpression]) {
                throw new NoExpressionValueException();
            }
            return this.expressionStack.get(this.expressionStack.size() - fromTop);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final void popExpressions(int count) throws NoExpressionValueException {
        try {
            int stop = this.topSubexpression != -1 ? this.subexpressionStackPos[this.topSubexpression] : -1;
            int remove = this.expressionStack.size() - 1;
            while (count-- > 0) {
                if (this.expressionStack.size() <= stop) {
                    throw new NoExpressionValueException();
                }
                this.expressionStack.remove(remove);
                this.expressionTypeStack.remove(remove--);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final Class popExpressionType(boolean allowVoid) throws NoExpressionValueException {
        try {
            Class result = (Class)this.expressionTypeStack.remove(this.expressionTypeStack.size() - 1);
            if (!allowVoid && result == Void.TYPE) {
                throw new NoExpressionValueException(InitparserTreeMessages.getString("ExpressionProcesser.PopExpressionType.ExpressionVoid_EXC_"));
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    protected final Class getExpressionType(int fromTop, boolean allowVoid) throws NoExpressionValueException {
        try {
            Class result = (Class)this.expressionTypeStack.get(this.expressionTypeStack.size() - fromTop);
            if (!allowVoid && result == Void.TYPE) {
                throw new NoExpressionValueException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoExpressionValueException();
        }
    }

    public ExpressionProcesser() {
        this(false, -1L);
    }

    public ExpressionProcesser(boolean traceOn, long threshold) {
        this.traceOn = traceOn;
        if (traceOn) {
            this.traceHeader = "**" + ++TRACE_COUNTER + ':';
            System.out.print(this.traceHeader);
            System.out.println(" Start expression");
            this.thresholdTime = threshold != -1L ? threshold : 100L;
            this.lastExpressionEndTime = this.startExpressionTime = System.currentTimeMillis();
        } else {
            this.traceHeader = null;
            this.thresholdTime = 100L;
        }
    }

    protected void printTrace(String msg, boolean ignore) {
        this.startExpressionStepTime = System.currentTimeMillis();
        long sinceLastExpression = this.startExpressionStepTime - this.lastExpressionEndTime;
        System.out.print(this.traceHeader);
        if (sinceLastExpression > 0L) {
            System.out.print('(');
            if (sinceLastExpression > this.thresholdTime) {
                System.out.print("***");
            }
            System.out.print(sinceLastExpression);
            System.out.print("ms)");
        }
        System.out.print('\t');
        if (!ignore) {
            System.out.print("\t");
        } else {
            System.out.print("##\t");
        }
        this.printIndent();
        System.out.print(msg);
    }

    protected void printIndent() {
        int i = this.indent;
        while (i > 0) {
            System.out.print("  ");
            --i;
        }
    }

    protected void printTraceEnd() {
        long stop = System.currentTimeMillis() - this.startExpressionStepTime;
        if (stop > 0L) {
            System.out.print(" (");
            if (stop > this.thresholdTime) {
                System.out.print("***");
            }
            System.out.print(stop);
            System.out.print("ms)");
        }
        System.out.println();
        this.lastExpressionEndTime = System.currentTimeMillis();
    }

    protected void indent(boolean indent) {
        this.indent += indent ? 1 : -1;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    protected void printObjectAndType(Object o, Class t) {
        System.out.print(' ');
        System.out.print("Object-");
        System.out.print(o);
        System.out.print(" Type-");
        System.out.print(t);
        System.out.print(' ');
    }

    public final void close() {
        boolean firstClose;
        boolean bl = firstClose = this.expressionStack != null;
        if (firstClose && this.traceOn) {
            this.printTrace("End expression", false);
            long totalTime = System.currentTimeMillis() - this.startExpressionTime;
            System.out.print(" Total expression evaluation time: ");
            System.out.print(totalTime);
            System.out.print("ms.");
        }
        try {
            this.expressionStack = null;
            this.expressionTypeStack = null;
            this.expressionProxies = null;
            this.exception = null;
            this.catchThrowable = null;
            this.saveStates = null;
        }
        finally {
            if (firstClose && this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pullValue(Object[] value) throws NoExpressionValueException {
        if (this.traceOn) {
            this.printTrace("Pull value:", false);
        }
        try {
            value[0] = this.popExpression();
            value[1] = this.popExpressionType(false);
        }
        finally {
            if (this.traceOn) {
                this.printObjectAndType(value[0], (Class)value[1]);
                this.printTraceEnd();
            }
        }
        this.close();
    }

    public final void pullExpressionProxyValue(int proxyid, Object[] value) throws NoExpressionValueException {
        this.getExpressionProxyValue(proxyid, value, true, true);
    }

    public boolean getExpressionProxyValue(int proxyid, Object[] value) {
        try {
            return this.getExpressionProxyValue(proxyid, value, true, false);
        }
        catch (NoExpressionValueException noExpressionValueException) {
            return false;
        }
    }

    public void getExpressionProxy(int proxyid, Object[] value) throws NoExpressionValueException {
        this.getExpressionProxyValue(proxyid, value, true, false);
    }

    private boolean getExpressionProxyValue(int proxyid, Object[] value, boolean pull, boolean finalTrace) throws NoExpressionValueException {
        boolean doTrace = finalTrace && this.traceOn;
        try {
            if (this.expressionProxies != null && this.expressionProxies.size() > proxyid) {
                InternalExpressionProxy proxy = (InternalExpressionProxy)this.expressionProxies.get(proxyid);
                if (proxy != null && proxy.isSet()) {
                    value[0] = proxy.getValue();
                    if (value[0] instanceof VariableReference) {
                        value[0] = ((VariableReference)value[0]).dereference();
                    }
                    value[1] = proxy.getType();
                    if (doTrace) {
                        if (value[1] != Void.TYPE) {
                            this.printTrace("Return Proxy #" + proxyid + " Resolved to", false);
                            this.printObjectAndType(value[0], (Class)value[1]);
                        } else {
                            this.printTrace("Return Proxy #" + proxyid + " Resolved to void.", false);
                        }
                    }
                    return true;
                }
                if (doTrace) {
                    this.printTrace("Return Proxy #" + proxyid + ": Not resolved", false);
                }
                NoExpressionValueException e = new NoExpressionValueException(InitparserTreeMessages.getString("ExpressionProcesser.GetExpressionProxyValue.ExpressionProxyNotSet_EXC_"), proxy);
                if (pull) {
                    throw e;
                }
                this.processSyntaxException(e);
                return false;
            }
            if (doTrace) {
                this.printTrace("Return Proxy #" + proxyid + ": Never created.", false);
            }
            NoExpressionValueException e = new NoExpressionValueException(InitparserTreeMessages.getString("ExpressionProcesser.GetExpressionProxyValue.ExpressionProxyDoesntExist_EXC_"));
            if (pull) {
                throw e;
            }
            this.processSyntaxException(e);
            return false;
        }
        finally {
            if (doTrace) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushExpression(Object o, Class t) {
        boolean ignore;
        boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
        if (this.traceOn) {
            this.printTrace("Push: ", ignore);
            this.printObjectAndType(o, t);
        }
        try {
            if (ignore) {
                return;
            }
            this.pushExpressionValue(o, t);
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushExpressionProxy(int proxyid) {
        boolean ignore;
        boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
        if (this.traceOn) {
            this.printTrace("Push Expression Proxy #" + proxyid, ignore);
        }
        try {
            if (ignore) {
                return;
            }
            if (this.expressionProxies != null && this.expressionProxies.size() > proxyid) {
                InternalExpressionProxy proxy = (InternalExpressionProxy)this.expressionProxies.get(proxyid);
                if (proxy != null && proxy.isSet()) {
                    if (this.traceOn) {
                        this.printObjectAndType(proxy.getValue(), proxy.getType());
                    }
                    this.pushExpressionValue(proxy.getValue(), proxy.getType());
                } else {
                    this.processException(new NoExpressionValueException("Proxy id: " + proxyid));
                }
            } else {
                this.processException(new NoExpressionValueException("Proxy id: " + proxyid));
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushCast(Class type) {
        boolean ignore;
        boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
        if (this.traceOn) {
            this.printTrace("Cast to: " + type, ignore);
        }
        try {
            if (ignore) {
                return;
            }
            try {
                Object exp = this.popExpression();
                Class exptype = this.popExpressionType(false);
                this.pushExpressionValue(this.castBean(type, exp, exptype), type);
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    protected final Object castBean(Class returnType, Object bean, Class beanType) throws ClassCastException {
        if (bean == null) {
            if (!returnType.isPrimitive()) {
                return bean;
            }
            this.throwClassCast(returnType, bean);
        } else {
            if (returnType.equals(bean.getClass())) {
                return bean;
            }
            if (!returnType.isPrimitive()) {
                if (!beanType.isPrimitive() && returnType.isInstance(bean)) {
                    return bean;
                }
                this.throwClassCast(returnType, bean);
            } else {
                if (!beanType.isPrimitive()) {
                    this.throwClassCast(returnType, bean);
                }
                if (returnType == Boolean.TYPE) {
                    if (bean instanceof Boolean) {
                        return bean;
                    }
                    this.throwClassCast(returnType, bean);
                } else if (bean instanceof Number) {
                    if (returnType == Integer.TYPE) {
                        if (bean instanceof Integer) {
                            return bean;
                        }
                        return new Integer(((Number)bean).intValue());
                    }
                    if (returnType == Byte.TYPE) {
                        if (bean instanceof Byte) {
                            return bean;
                        }
                        return new Byte(((Number)bean).byteValue());
                    }
                    if (returnType == Character.TYPE) {
                        if (bean instanceof Character) {
                            return bean;
                        }
                        return new Character((char)((Number)bean).intValue());
                    }
                    if (returnType == Double.TYPE) {
                        if (bean instanceof Double) {
                            return bean;
                        }
                        return new Double(((Number)bean).doubleValue());
                    }
                    if (returnType == Float.TYPE) {
                        if (bean instanceof Float) {
                            return bean;
                        }
                        return new Float(((Number)bean).floatValue());
                    }
                    if (returnType == Long.TYPE) {
                        if (bean instanceof Long) {
                            return bean;
                        }
                        return new Long(((Number)bean).longValue());
                    }
                    if (returnType == Short.TYPE) {
                        if (bean instanceof Short) {
                            return bean;
                        }
                        return new Short(((Number)bean).shortValue());
                    }
                    this.throwClassCast(returnType, bean);
                } else if (bean instanceof Character) {
                    if (returnType == Character.TYPE) {
                        return bean;
                    }
                    if (returnType == Integer.TYPE) {
                        return new Integer(((Character)bean).charValue());
                    }
                    if (returnType == Byte.TYPE) {
                        return new Byte((byte)((Character)bean).charValue());
                    }
                    if (returnType == Double.TYPE) {
                        return new Double(((Character)bean).charValue());
                    }
                    if (returnType == Float.TYPE) {
                        return new Float(((Character)bean).charValue());
                    }
                    if (returnType == Long.TYPE) {
                        return new Long(((Character)bean).charValue());
                    }
                    if (returnType == Short.TYPE) {
                        return new Short((short)((Character)bean).charValue());
                    }
                    this.throwClassCast(returnType, bean);
                } else {
                    this.throwClassCast(returnType, bean);
                }
            }
        }
        return null;
    }

    private void throwClassCast(Class returnType, Object bean) throws ClassCastException {
        throw new ClassCastException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CannotCastXToY_EXC_"), bean != null ? bean.getClass().getName() : null, returnType.getName()));
    }

    protected final Class getPrimitiveType(Object bean) throws IllegalArgumentException {
        if (bean instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (bean instanceof Integer) {
            return Integer.TYPE;
        }
        if (bean instanceof Byte) {
            return Byte.TYPE;
        }
        if (bean instanceof Character) {
            return Character.TYPE;
        }
        if (bean instanceof Double) {
            return Double.TYPE;
        }
        if (bean instanceof Float) {
            return Float.TYPE;
        }
        if (bean instanceof Long) {
            return Long.TYPE;
        }
        if (bean instanceof Short) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException(bean != null ? bean.getClass().getName() : "null");
    }

    public final void pushIfElse() {
        try {
            boolean ignore = true;
            try {
                if (this.errorOccurred) {
                    return;
                }
                ++this.ifElseNesting;
                if (this.ignoreExpression != null) {
                    return;
                }
                ignore = false;
            }
            finally {
                if (this.traceOn) {
                    this.printTrace("If test condition", ignore);
                }
            }
            try {
                Object condition = this.popExpression();
                Class type = this.popExpressionType(false);
                if (type != Boolean.TYPE) {
                    this.throwClassCast(Boolean.TYPE, condition);
                }
                if (this.traceOn) {
                    System.out.print(" Test Result=" + condition);
                    this.printTraceEnd();
                    this.indent(true);
                    this.printTrace("Begin True Expression.", ignore);
                    this.printTraceEnd();
                    this.indent(true);
                }
                if (!((Boolean)condition).booleanValue()) {
                    this.ifElseSkipTruePart = true;
                    this.ignoreExpression = IFELSE_IGNORE;
                    this.ifElseIgnoreNestCount = this.ifElseNesting;
                }
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushIfElse(InternalIfElseOperandType clauseType) {
        try {
            boolean ignore = true;
            if (this.errorOccurred) {
                return;
            }
            switch (clauseType.getValue()) {
                case 1: {
                    if (this.traceOn) {
                        this.indent(false);
                        this.printTrace("Begin False Expression.", ignore);
                        this.printTraceEnd();
                        this.indent(true);
                    }
                    if (!this.ifElseSkipTruePart || this.ignoreExpression != IFELSE_IGNORE || this.ifElseIgnoreNestCount != this.ifElseNesting) break;
                    this.ignoreExpression = null;
                    return;
                }
                case 0: {
                    if (this.traceOn) {
                        this.indent(false);
                        this.indent(false);
                        this.printTrace("End IF/ELSE Expression.", ignore);
                        this.printTraceEnd();
                    }
                    int currentNesting = this.ifElseNesting--;
                    if (this.ignoreExpression != IFELSE_IGNORE || this.ifElseIgnoreNestCount != currentNesting) break;
                    this.ignoreExpression = null;
                    return;
                }
            }
            if (this.ignoreExpression != null) {
                return;
            }
            ignore = false;
            try {
                switch (clauseType.getValue()) {
                    case 1: {
                        this.ifElseSkipTruePart = false;
                        this.ignoreExpression = IFELSE_IGNORE;
                        this.ifElseIgnoreNestCount = this.ifElseNesting;
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushInstanceof(Class type) {
        boolean ignore;
        boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
        if (this.traceOn) {
            this.printTrace("Instanceof type: " + type, ignore);
        }
        try {
            if (ignore) {
                return;
            }
            try {
                Object exp = this.popExpression();
                Class exptype = this.popExpressionType(false);
                this.pushExpressionValue(this.isInstance(type, exp, exptype), Boolean.TYPE);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    protected final boolean isInstance(Class type, Object bean, Class beanType) {
        if (type.isPrimitive()) {
            return beanType.isPrimitive() && type == beanType;
        }
        return type.isInstance(bean);
    }

    public final void pushNewInstanceFromString(String initializationString, Class resultType, ClassLoader classloader) {
        boolean ignore;
        boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
        if (this.traceOn) {
            this.printTrace("New instance from string: \"" + initializationString + "\" Type=" + resultType, ignore);
        }
        try {
            if (ignore) {
                return;
            }
            try {
                InitializationStringParser parser = InitializationStringParser.createParser(initializationString, classloader);
                Object newValue = parser.evaluate();
                newValue = this.castBean(resultType, newValue, parser.getExpectedType());
                this.pushExpressionValue(newValue, resultType);
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
            catch (InitializationStringEvaluationException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushPrefix(PrefixOperator operator) {
        try {
            if (this.ignoreExpression != null || this.errorOccurred) {
                if (this.traceOn) {
                    this.printTrace("Prefix: '" + operator + "'", true);
                }
                return;
            }
            if (operator == PrefixOperator.PRE_PLUS) {
                return;
            }
            if (this.traceOn) {
                this.printTrace("Prefix: '" + operator + "' ", false);
            }
            try {
                Object exp = this.popExpression();
                Class exptype = this.popExpressionType(false);
                if (!exptype.isPrimitive()) {
                    this.throwInvalidPrefix(operator, exp);
                }
                int primTypeEnum = this.getEnumForPrimitive(exptype);
                block4 : switch (operator.getValue()) {
                    case 1: {
                        switch (primTypeEnum) {
                            case 0: {
                                this.throwInvalidPrefix(operator, exp);
                            }
                            case 1: {
                                exp = new Integer(-((Number)exp).byteValue());
                                break;
                            }
                            case 3: {
                                exp = new Integer(-((Character)exp).charValue());
                                break;
                            }
                            case 7: {
                                exp = new Double(-((Number)exp).doubleValue());
                                break;
                            }
                            case 6: {
                                exp = new Float(-((Number)exp).floatValue());
                                break;
                            }
                            case 4: {
                                exp = new Integer(-((Number)exp).intValue());
                                break;
                            }
                            case 5: {
                                exp = new Long(-((Number)exp).longValue());
                                break;
                            }
                            case 2: {
                                exp = new Integer(-((Number)exp).shortValue());
                            }
                        }
                        exptype = this.getPrimitiveType(exp);
                        break;
                    }
                    case 2: {
                        switch (primTypeEnum) {
                            case 0: 
                            case 6: 
                            case 7: {
                                this.throwInvalidPrefix(operator, exp);
                            }
                            case 1: {
                                exp = new Integer(~((Number)exp).byteValue());
                                break;
                            }
                            case 3: {
                                exp = new Integer(~((Character)exp).charValue());
                                break;
                            }
                            case 4: {
                                exp = new Integer(~((Number)exp).intValue());
                                break;
                            }
                            case 5: {
                                exp = new Long(((Number)exp).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                                break;
                            }
                            case 2: {
                                exp = new Integer(~((Number)exp).shortValue());
                            }
                        }
                        exptype = this.getPrimitiveType(exp);
                        break;
                    }
                    case 3: {
                        switch (primTypeEnum) {
                            case 0: {
                                exp = (Boolean)exp == false ? Boolean.TRUE : Boolean.FALSE;
                                break block4;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.throwInvalidPrefix(operator, exp);
                            }
                        }
                    }
                }
                if (this.traceOn) {
                    this.printObjectAndType(exp, exptype);
                }
                this.pushExpressionValue(exp, exptype);
            }
            catch (IllegalArgumentException e) {
                this.processSyntaxException(e);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushAssignment() {
        if (this.ignoreExpression != null || this.errorOccurred) {
            if (this.traceOn) {
                this.printTrace("Assignment", true);
                this.printTraceEnd();
            }
            return;
        }
        try {
            Object leftValue;
            Class refType;
            try {
                if (this.traceOn) {
                    this.printTrace("Assignment: ", false);
                }
                Object value = this.popExpression();
                Class type = this.popExpressionType(false);
                VariableReference left = (VariableReference)this.popExpression(false);
                refType = this.popExpressionType(false);
                if (this.traceOn) {
                    this.printObjectAndType(left, refType);
                }
                leftValue = left.set(value, type);
            }
            finally {
                if (this.traceOn) {
                    this.printTraceEnd();
                }
            }
            this.pushExpression(leftValue, refType);
        }
        catch (IllegalArgumentException e) {
            this.processException(e);
        }
        catch (NoExpressionValueException e) {
            this.processException(e);
        }
        catch (IllegalAccessException e) {
            this.processException(e);
        }
        catch (RuntimeException e) {
            this.processException(e);
        }
    }

    public final void pushAssignment(InternalExpressionProxy proxy) {
        boolean ignore = this.ignoreExpression != null || this.errorOccurred;
        try {
            if (this.traceOn) {
                this.printTrace("Assign to Proxy #" + proxy.getProxyID(), ignore);
            }
            if (ignore) {
                return;
            }
            try {
                this.assignToExpressionProxyFromTopStackEntry(proxy);
                if (this.traceOn) {
                    this.printObjectAndType(proxy.getValue(), proxy.getType());
                }
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    protected void assignToExpressionProxyFromTopStackEntry(InternalExpressionProxy proxy) throws NoExpressionValueException {
        Object value = this.getExpression(1);
        Class type = this.getExpressionType(1, true);
        if (value instanceof VariableReference) {
            value = ((VariableReference)value).dereference();
        }
        proxy.setProxy(value, type);
        this.allocateExpressionProxy(proxy);
    }

    public void allocateExpressionProxy(InternalExpressionProxy proxy) {
        int minSize = proxy.getProxyID() + 1;
        if (this.expressionProxies == null) {
            this.expressionProxies = new ArrayList(minSize + 10);
        } else if (this.expressionProxies.size() < minSize) {
            this.expressionProxies.ensureCapacity(minSize + 10);
        }
        int fill = minSize - this.expressionProxies.size();
        if (fill > 0) {
            while (--fill > 0) {
                this.expressionProxies.add(null);
            }
            this.expressionProxies.add(proxy);
        } else {
            this.expressionProxies.set(proxy.getProxyID(), proxy);
        }
    }

    protected final int getEnumForPrimitive(Class primitiveType) throws IllegalArgumentException {
        if (primitiveType == Boolean.TYPE) {
            return 0;
        }
        if (primitiveType == Integer.TYPE) {
            return 4;
        }
        if (primitiveType == Byte.TYPE) {
            return 1;
        }
        if (primitiveType == Character.TYPE) {
            return 3;
        }
        if (primitiveType == Double.TYPE) {
            return 7;
        }
        if (primitiveType == Float.TYPE) {
            return 6;
        }
        if (primitiveType == Long.TYPE) {
            return 5;
        }
        if (primitiveType == Short.TYPE) {
            return 2;
        }
        throw new IllegalArgumentException(primitiveType != null ? primitiveType.getName() : "null");
    }

    private void throwInvalidPrefix(PrefixOperator operator, Object exp) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.InvalidOperandOfPrefixOperator_EXC_"), exp != null ? exp.toString() : null, operator.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pushInfix(InfixOperator operator, InternalInfixOperandType operandType) {
        try {
            boolean ignore = true;
            try {
                if (this.errorOccurred) {
                    return;
                }
                if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) {
                    ++this.infixNesting;
                } else if (operandType == InternalInfixOperandType.INFIX_LAST_OPERAND) {
                    int currentNest = this.infixNesting--;
                    if (this.ignoreExpression == INFIX_IGNORE && currentNest == this.infixIgnoreNestCount) {
                        this.ignoreExpression = null;
                        return;
                    }
                }
                if (this.ignoreExpression != null) {
                    return;
                }
                ignore = false;
            }
            finally {
                if (this.traceOn) {
                    this.printTrace("Infix: " + operator, ignore);
                }
            }
            try {
                Object right = null;
                Class rightType = null;
                if (operandType != InternalInfixOperandType.INFIX_LEFT_OPERAND) {
                    right = this.popExpression();
                    rightType = this.popExpressionType(false);
                }
                Object value = this.popExpression();
                Class<Object> valueType = this.popExpressionType(false);
                switch (operator.getValue()) {
                    case 15: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidBitType(valueType, InfixOperator.IN_AND);
                        this.testValidBitType(rightType, InfixOperator.IN_AND);
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) & this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) & this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 17: {
                        if (operandType != InternalInfixOperandType.INFIX_LEFT_OPERAND) {
                            value = right;
                            valueType = rightType;
                        }
                        if (valueType != Boolean.TYPE) {
                            this.throwInvalidInfix(operator, value);
                        }
                        if (((Boolean)value).booleanValue() || operandType == InternalInfixOperandType.INFIX_LAST_OPERAND) break;
                        this.startInfixIgnore();
                        break;
                    }
                    case 18: {
                        if (operandType != InternalInfixOperandType.INFIX_LEFT_OPERAND) {
                            value = right;
                            valueType = rightType;
                        }
                        if (valueType != Boolean.TYPE) {
                            this.throwInvalidInfix(operator, value);
                        }
                        if (!((Boolean)value).booleanValue() || operandType == InternalInfixOperandType.INFIX_LAST_OPERAND) break;
                        this.startInfixIgnore();
                        break;
                    }
                    case 1: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_DIVIDE);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_DIVIDE);
                        if (valueType == Double.TYPE || rightType == Double.TYPE) {
                            value = new Double(this.getDouble(value) / this.getDouble(right));
                            valueType = Double.TYPE;
                            break;
                        }
                        if (valueType == Float.TYPE || rightType == Float.TYPE) {
                            value = new Float(this.getFloat(value) / this.getFloat(right));
                            valueType = Float.TYPE;
                            break;
                        }
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) / this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) / this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 12: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        value = valueType.isPrimitive() && rightType.isPrimitive() ? (valueType == Boolean.TYPE || rightType == Boolean.TYPE ? (valueType != Boolean.TYPE || valueType != Boolean.TYPE ? Boolean.FALSE : (((Boolean)value).booleanValue() == ((Boolean)right).booleanValue() ? Boolean.TRUE : Boolean.FALSE)) : (valueType == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) == this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) == this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) == this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) == this.getInt(right) ? Boolean.TRUE : Boolean.FALSE))))) : (valueType.isPrimitive() || rightType.isPrimitive() ? Boolean.FALSE : (value == right ? Boolean.TRUE : Boolean.FALSE));
                        valueType = Boolean.TYPE;
                        break;
                    }
                    case 9: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_GREATER);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_GREATER);
                        value = valueType == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) > this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) > this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) > this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) > this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                        valueType = Boolean.TYPE;
                        break;
                    }
                    case 11: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_GREATER_EQUALS);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_GREATER_EQUALS);
                        value = valueType == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) >= this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) >= this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) >= this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) >= this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                        valueType = Boolean.TYPE;
                        break;
                    }
                    case 5: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidBitType(valueType, InfixOperator.IN_LEFT_SHIFT);
                        this.testValidBitType(rightType, InfixOperator.IN_LEFT_SHIFT);
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) << (int)this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) << this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 8: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_LESS);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_LESS);
                        value = valueType == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) < this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) < this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) < this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) < this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                        valueType = Boolean.TYPE;
                        break;
                    }
                    case 10: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_LESS_EQUALS);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_LESS_EQUALS);
                        value = valueType == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) <= this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) <= this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) <= this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) <= this.getInt(right) ? Boolean.TRUE : Boolean.FALSE)));
                        valueType = Boolean.TYPE;
                        break;
                    }
                    case 4: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_MINUS);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_MINUS);
                        if (valueType == Double.TYPE || rightType == Double.TYPE) {
                            value = new Double(this.getDouble(value) - this.getDouble(right));
                            valueType = Double.TYPE;
                            break;
                        }
                        if (valueType == Float.TYPE || rightType == Float.TYPE) {
                            value = new Float(this.getFloat(value) - this.getFloat(right));
                            valueType = Float.TYPE;
                            break;
                        }
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) - this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) - this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 13: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        value = valueType.isPrimitive() && rightType.isPrimitive() ? (valueType == Boolean.TYPE || rightType == Boolean.TYPE ? (valueType != Boolean.TYPE || valueType != Boolean.TYPE ? Boolean.TRUE : (((Boolean)value).booleanValue() != ((Boolean)right).booleanValue() ? Boolean.TRUE : Boolean.FALSE)) : (valueType == Double.TYPE || rightType == Double.TYPE ? (this.getDouble(value) != this.getDouble(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Float.TYPE || rightType == Float.TYPE ? (this.getFloat(value) != this.getFloat(right) ? Boolean.TRUE : Boolean.FALSE) : (valueType == Long.TYPE || rightType == Long.TYPE ? (this.getLong(value) != this.getLong(right) ? Boolean.TRUE : Boolean.FALSE) : (this.getInt(value) != this.getInt(right) ? Boolean.TRUE : Boolean.FALSE))))) : (valueType.isPrimitive() || rightType.isPrimitive() ? Boolean.TRUE : (value != right ? Boolean.TRUE : Boolean.FALSE));
                        valueType = Boolean.TYPE;
                        break;
                    }
                    case 16: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidBitType(valueType, InfixOperator.IN_OR);
                        this.testValidBitType(rightType, InfixOperator.IN_OR);
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) | this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) | this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 3: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) {
                            if (valueType != String.class) break;
                            value = new StringBuffer((String)value);
                            break;
                        }
                        this.testValidPlusType(valueType, rightType);
                        if (valueType == String.class || rightType == String.class) {
                            StringBuffer sb = null;
                            if (valueType == String.class) {
                                sb = (StringBuffer)value;
                            } else {
                                sb = new StringBuffer(((String)right).length() + 16);
                                this.appendToBuffer(sb, value, valueType);
                                value = sb;
                                valueType = String.class;
                            }
                            this.appendToBuffer(sb, right, rightType);
                            if (operandType != InternalInfixOperandType.INFIX_LAST_OPERAND) break;
                            value = sb.toString();
                            break;
                        }
                        if (valueType == Double.TYPE || rightType == Double.TYPE) {
                            value = new Double(this.getDouble(value) + this.getDouble(right));
                            valueType = Double.TYPE;
                            break;
                        }
                        if (valueType == Float.TYPE || rightType == Float.TYPE) {
                            value = new Float(this.getFloat(value) + this.getFloat(right));
                            valueType = Float.TYPE;
                            break;
                        }
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) + this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) + this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 2: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_REMAINDER);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_REMAINDER);
                        if (valueType == Double.TYPE || rightType == Double.TYPE) {
                            value = new Double(this.getDouble(value) % this.getDouble(right));
                            valueType = Double.TYPE;
                            break;
                        }
                        if (valueType == Float.TYPE || rightType == Float.TYPE) {
                            value = new Float(this.getFloat(value) % this.getFloat(right));
                            valueType = Float.TYPE;
                            break;
                        }
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) % this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) % this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 6: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidBitType(valueType, InfixOperator.IN_RIGHT_SHIFT_SIGNED);
                        this.testValidBitType(rightType, InfixOperator.IN_RIGHT_SHIFT_SIGNED);
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) >> (int)this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) >> this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 7: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidBitType(valueType, InfixOperator.IN_RIGHT_SHIFT_UNSIGNED);
                        this.testValidBitType(rightType, InfixOperator.IN_RIGHT_SHIFT_UNSIGNED);
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) >>> (int)this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) >>> this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 0: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidArithmeticType(valueType, InfixOperator.IN_TIMES);
                        this.testValidArithmeticType(rightType, InfixOperator.IN_TIMES);
                        if (valueType == Double.TYPE || rightType == Double.TYPE) {
                            value = new Double(this.getDouble(value) * this.getDouble(right));
                            valueType = Double.TYPE;
                            break;
                        }
                        if (valueType == Float.TYPE || rightType == Float.TYPE) {
                            value = new Float(this.getFloat(value) * this.getFloat(right));
                            valueType = Float.TYPE;
                            break;
                        }
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) * this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) * this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                    case 14: {
                        if (operandType == InternalInfixOperandType.INFIX_LEFT_OPERAND) break;
                        this.testValidBitType(valueType, InfixOperator.IN_XOR);
                        this.testValidBitType(rightType, InfixOperator.IN_XOR);
                        if (valueType == Long.TYPE || rightType == Long.TYPE) {
                            value = new Long(this.getLong(value) ^ this.getLong(right));
                            valueType = Long.TYPE;
                            break;
                        }
                        value = new Integer(this.getInt(value) ^ this.getInt(right));
                        valueType = Integer.TYPE;
                        break;
                    }
                }
                if (this.traceOn) {
                    this.printObjectAndType(value, valueType);
                }
                this.pushExpressionValue(value, valueType);
                return;
            }
            catch (IllegalArgumentException e) {
                this.processException(e);
                return;
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
                return;
            }
            catch (RuntimeException e) {
                this.processException(e);
                return;
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    private void startInfixIgnore() {
        this.ignoreExpression = INFIX_IGNORE;
        this.infixIgnoreNestCount = this.infixNesting;
    }

    protected final int getInt(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).intValue() : (int)((Character)bean).charValue();
    }

    protected final float getFloat(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).floatValue() : (float)((Character)bean).charValue();
    }

    protected final double getDouble(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).doubleValue() : (double)((Character)bean).charValue();
    }

    protected final long getLong(Object bean) throws ClassCastException {
        return bean instanceof Number ? ((Number)bean).longValue() : (long)((Character)bean).charValue();
    }

    private void throwInvalidInfix(InfixOperator operator, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.InvalidOperandOfOperator_EXC_"), value != null ? value.toString() : null, operator.toString()));
    }

    private void testValidBitType(Class type, InfixOperator operator) {
        if (!type.isPrimitive() || type == Boolean.TYPE || type == Double.TYPE || type == Float.TYPE) {
            this.throwInvalidInfix(operator, type);
        }
    }

    private void testValidArithmeticType(Class type, InfixOperator operator) {
        if (!type.isPrimitive() || type == Boolean.TYPE) {
            this.throwInvalidInfix(operator, type);
        }
    }

    private void testValidPlusType(Class left, Class right) {
        if (left == String.class || right == String.class) {
            return;
        }
        this.testValidArithmeticType(left, InfixOperator.IN_PLUS);
        this.testValidArithmeticType(right, InfixOperator.IN_PLUS);
    }

    private void appendToBuffer(StringBuffer sb, Object value, Class valueType) {
        if (value == null) {
            sb.append((Object)null);
        } else if (valueType == String.class) {
            sb.append((String)value);
        } else if (valueType.isPrimitive()) {
            switch (this.getEnumForPrimitive(valueType)) {
                case 0: {
                    sb.append((Boolean)value);
                    break;
                }
                case 1: {
                    sb.append(((Number)value).byteValue());
                    break;
                }
                case 3: {
                    sb.append(((Character)value).charValue());
                    break;
                }
                case 7: {
                    sb.append(((Number)value).doubleValue());
                    break;
                }
                case 6: {
                    sb.append(((Number)value).floatValue());
                    break;
                }
                case 4: {
                    sb.append(((Number)value).intValue());
                    break;
                }
                case 5: {
                    sb.append(((Number)value).longValue());
                    break;
                }
                case 2: {
                    sb.append(((Number)value).shortValue());
                }
            }
        } else {
            sb.append(value);
        }
    }

    public final void pushArrayAccess(int indexCount) {
        block18: {
            boolean ignore;
            boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
            if (this.traceOn) {
                this.printTrace("Array Access[" + indexCount + ']', ignore);
            }
            try {
                if (ignore) {
                    return;
                }
                try {
                    int[] arguments = new int[indexCount];
                    int i = indexCount - 1;
                    while (i >= 0) {
                        Object index = this.popExpression();
                        Class indexType = this.popExpressionType(false);
                        if (indexType.isPrimitive() && (indexType == Integer.TYPE || indexType == Short.TYPE || indexType == Character.TYPE || indexType == Byte.TYPE)) {
                            arguments[i] = this.getInt(index);
                        } else {
                            this.throwClassCast(Integer.TYPE, index);
                        }
                        --i;
                    }
                    Object array = this.popExpression();
                    Class<?> arrayType = this.popExpressionType(false);
                    if (arrayType.isArray()) {
                        int dimcount = 0;
                        Class[] componentTypes = new Class[indexCount];
                        Class<?> componentType = arrayType;
                        while (dimcount < indexCount && componentType.isArray()) {
                            componentTypes[dimcount++] = componentType = componentType.getComponentType();
                        }
                        if (dimcount < indexCount) {
                            throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.XIsGreaterThanNumberOfDimensionsInArray_EXC_"), new Integer(indexCount), new Integer(dimcount)));
                        }
                        Object value = array;
                        int pullCount = indexCount - 1;
                        int i2 = 0;
                        while (i2 < pullCount) {
                            value = Array.get(value, arguments[i2]);
                            ++i2;
                        }
                        ArrayAccessReference arrayValue = ArrayAccessReference.createArrayAccessReference(value, arguments[pullCount]);
                        if (this.traceOn) {
                            this.printObjectAndType(arrayValue, componentTypes[pullCount]);
                        }
                        this.pushExpressionValue(arrayValue, componentTypes[pullCount]);
                        break block18;
                    }
                    throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.NotAnArray_EXC_"), arrayType));
                }
                catch (NoExpressionValueException e) {
                    this.processException(e);
                }
                catch (RuntimeException e) {
                    this.processException(e);
                }
            }
            finally {
                if (this.traceOn) {
                    this.printTraceEnd();
                }
            }
        }
    }

    public final void pushArrayCreation(Class arrayType, int dimensionCount) {
        boolean ignore;
        boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
        if (this.traceOn) {
            this.printTrace("Array Creation: " + arrayType.getName() + '[' + dimensionCount + ']', ignore);
        }
        try {
            if (ignore) {
                return;
            }
            try {
                if (dimensionCount != 0) {
                    Class<?> componentType = arrayType;
                    int i = 0;
                    while (i < dimensionCount && componentType != null) {
                        componentType = componentType.getComponentType();
                        ++i;
                    }
                    if (componentType == null) {
                        throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.ArraytypeHasFewerDimensionsThanRequested_EXC_"), arrayType, new Integer(dimensionCount)));
                    }
                    int[] dimInit = new int[dimensionCount];
                    int i2 = dimensionCount - 1;
                    while (i2 >= 0) {
                        Object index = this.popExpression();
                        Class dimType = this.popExpressionType(false);
                        if (dimType.isPrimitive() && (dimType == Integer.TYPE || dimType == Short.TYPE || dimType == Character.TYPE || dimType == Byte.TYPE)) {
                            dimInit[i2] = this.getInt(index);
                        } else {
                            this.throwClassCast(Integer.TYPE, index);
                        }
                        --i2;
                    }
                    Object array = Array.newInstance(componentType, dimInit);
                    this.pushExpressionValue(array, arrayType);
                }
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void pushArrayInitializer(Class arrayType, int stripCount, int expressionCount) {
        v0 = ignore = this.ignoreExpression != null || this.errorOccurred != false;
        if (this.traceOn) {
            this.printTrace("Initialize Array: " + arrayType.getName() + '{' + expressionCount + '}', ignore);
        }
        try {
            if (ignore) {
                return;
            }
            try {
                if (arrayType.isArray()) ** GOTO lbl11
                throw new ClassCastException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CannotCastXToY_EXC_"), new Object[]{arrayType, "array"}));
lbl-1000:
                // 1 sources

                {
                    arrayType = arrayType.getComponentType();
lbl11:
                    // 2 sources

                    ** while (stripCount-- > 0)
                }
lbl12:
                // 1 sources

                dimValues = null;
                if (expressionCount > 0) {
                    dimValues = new Object[expressionCount];
                    i = expressionCount - 1;
                    while (i >= 0) {
                        dimValue = dimValues[i] = this.popExpression();
                        dimType = this.popExpressionType(false);
                        if (arrayType.isPrimitive()) {
                            if (dimValue == null || !dimType.isPrimitive()) {
                                this.throwClassCast(arrayType, dimType);
                            }
                            if (arrayType != dimType) {
                                compEnum = this.getEnumForPrimitive(arrayType);
                                dimEnum = this.getEnumForPrimitive(dimType);
                                if (compEnum == 0 || dimEnum == 0) {
                                    this.throwClassCast(arrayType, dimType);
                                }
                                dimValueAsInt = this.getInt(dimValue);
                                switch (compEnum) {
                                    case 1: {
                                        if (dimEnum > 4 || dimValueAsInt > 127 || dimValueAsInt < -128) {
                                            this.throwClassCast(arrayType, dimType);
                                        }
                                        dimValues[i] = new Byte((byte)dimValueAsInt);
                                        break;
                                    }
                                    case 2: {
                                        if (dimEnum > 4 || dimValueAsInt > 32767 || dimValueAsInt < -32768) {
                                            this.throwClassCast(arrayType, dimType);
                                        }
                                        dimValues[i] = new Short((short)dimValueAsInt);
                                        break;
                                    }
                                    case 3: {
                                        if (dimEnum > 4 || dimValueAsInt > 65535 || dimValueAsInt < 0) {
                                            this.throwClassCast(arrayType, dimType);
                                        }
                                        dimValues[i] = new Character((char)dimValueAsInt);
                                        break;
                                    }
                                    case 4: {
                                        if (dimEnum > 4) {
                                            this.throwClassCast(arrayType, dimType);
                                        }
                                        dimValues[i] = new Integer(dimValueAsInt);
                                        break;
                                    }
                                    case 5: {
                                        if (dimEnum > 5) {
                                            this.throwClassCast(arrayType, dimType);
                                        }
                                        dimValues[i] = new Long(this.getLong(dimValue));
                                        break;
                                    }
                                    case 6: {
                                        if (dimEnum > 6) {
                                            this.throwClassCast(arrayType, dimType);
                                        }
                                        dimValues[i] = new Float(this.getFloat(dimValue));
                                        break;
                                    }
                                    case 7: {
                                        dimValues[i] = new Double(this.getDouble(dimValue));
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        } else if (dimType != MethodHelper.NULL_TYPE && !arrayType.isAssignableFrom(dimType)) {
                            this.throwClassCast(arrayType, dimType);
                        }
                        --i;
                    }
                }
                array = Array.newInstance(arrayType, new int[]{expressionCount});
                i = 0;
                while (i < expressionCount) {
                    Array.set(array, i, dimValues[i]);
                    ++i;
                }
                this.pushExpressionValue(array, array.getClass());
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushClassInstanceCreation(Class type, int argumentCount) {
        block22: {
            boolean ignore;
            boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
            if (this.traceOn) {
                this.printTrace("Create Class: " + type + " (", ignore);
            }
            try {
                if (ignore) {
                    return;
                }
                try {
                    Object value = null;
                    Object[] args = new Object[argumentCount];
                    Class[] argTypes = new Class[argumentCount];
                    int i = argumentCount - 1;
                    while (i >= 0) {
                        args[i] = this.popExpression();
                        argTypes[i] = this.popExpressionType(false);
                        --i;
                    }
                    Constructor ctor = MethodHelper.findCompatibleConstructor(type, argTypes);
                    if (this.traceOn) {
                        if (argumentCount == 0) {
                            System.out.print("Default ctor)");
                        } else {
                            System.out.print(ctor);
                            System.out.print(')');
                        }
                    }
                    value = ctor.newInstance(args);
                    this.pushExpressionValue(value, type);
                }
                catch (RuntimeException e) {
                    this.processException(e);
                }
                catch (NoExpressionValueException e) {
                    this.processException(e);
                }
                catch (InstantiationException e) {
                    this.processException(e);
                }
                catch (IllegalAccessException e) {
                    this.processException(e);
                }
                catch (InvocationTargetException e) {
                    this.processException(e);
                }
                catch (NoSuchMethodException e) {
                    this.processException(e);
                }
                catch (AmbiguousMethodException e) {
                    this.processException(e);
                }
                catch (LinkageError e) {
                    this.processException(e);
                }
                catch (Error e) {
                    if (e.getClass() == Error.class) {
                        this.processException(new UnresolvedCompilationError(e));
                        break block22;
                    }
                    throw e;
                }
            }
            finally {
                if (this.traceOn) {
                    this.printTraceEnd();
                }
            }
        }
    }

    public final void pushFieldAccess(Object field, boolean fieldIsString, boolean hasReceiver) {
        try {
            if (this.ignoreExpression != null || this.errorOccurred) {
                if (this.traceOn) {
                    this.printTrace("Field Access", true);
                }
                return;
            }
            if (this.traceOn) {
                this.printTrace("Field Access: ", false);
            }
            try {
                Object receiver = null;
                Class receiverType = null;
                if (hasReceiver) {
                    receiver = this.popExpression();
                    receiverType = this.popExpressionType(false);
                }
                Field reflectField = fieldIsString ? receiverType.getField((String)field) : (Field)field;
                FieldAccessReference value = FieldAccessReference.createFieldAccessReference(reflectField, receiver);
                Class<?> valueType = reflectField.getType();
                if (this.traceOn) {
                    System.out.print("Field: ");
                    if (fieldIsString) {
                        System.out.print("(looked up) ");
                    }
                    System.out.print(reflectField);
                    System.out.print(">");
                    this.printObjectAndType(value, valueType);
                }
                this.pushExpressionValue(value, valueType);
            }
            catch (RuntimeException e) {
                this.processException(e);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
            catch (NoSuchFieldException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushMethodInvocation(Object method, boolean methodIsString, boolean hasReceiver, int argCount) {
        try {
            if (this.ignoreExpression != null || this.errorOccurred) {
                if (this.traceOn) {
                    this.printTrace("Invoke", true);
                }
                return;
            }
            if (this.traceOn) {
                this.printTrace("Invoke: ", false);
            }
            Method reflectMethod = null;
            try {
                Object[] args = new Object[argCount];
                Class[] argTypes = new Class[argCount];
                int i = argCount - 1;
                while (i >= 0) {
                    args[i] = this.popExpression();
                    argTypes[i] = this.popExpressionType(false);
                    --i;
                }
                Object receiver = null;
                Class receiverType = null;
                if (hasReceiver) {
                    receiver = this.popExpression();
                    receiverType = this.popExpressionType(false);
                }
                reflectMethod = methodIsString ? MethodHelper.findCompatibleMethod(receiverType, (String)method, argTypes) : (Method)method;
                if (this.traceOn && reflectMethod != null) {
                    System.out.print("Method: ");
                    if (methodIsString) {
                        System.out.print("(looked up) ");
                    }
                    System.out.print(reflectMethod);
                }
                if (!Modifier.isStatic(reflectMethod.getModifiers()) && receiver == null) {
                    throw new NullPointerException("No receiver for non-static method: " + reflectMethod.toString());
                }
                Object value = reflectMethod.invoke(receiver, args);
                if (this.traceOn) {
                    System.out.print(" returns: ");
                    this.printObjectAndType(value, reflectMethod.getReturnType());
                }
                this.pushExpressionValue(value, reflectMethod.getReturnType());
            }
            catch (RuntimeException e) {
                this.processException(this.fixUpMethodException(e, reflectMethod));
            }
            catch (NoExpressionValueException e) {
                this.processException(this.fixUpMethodException(e, reflectMethod));
            }
            catch (IllegalAccessException e) {
                this.processException(this.fixUpMethodException(e, reflectMethod));
            }
            catch (InvocationTargetException e) {
                this.processException(this.fixUpMethodException(e.getCause(), reflectMethod));
            }
            catch (NoSuchMethodException e) {
                this.processException(e);
            }
            catch (AmbiguousMethodException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    private Throwable fixUpMethodException(Throwable e, Method method) {
        if (method == null) {
            return e;
        }
        try {
            String msg = e.getMessage();
            Constructor<?> eWithStringCtor = e.getClass().getConstructor(String.class);
            String newMsg = msg == null ? method.toString() : String.valueOf(method.toString()) + ": \"" + msg + '\"';
            Exception fixedupE = (Exception)eWithStringCtor.newInstance(newMsg);
            fixedupE.setStackTrace(e.getStackTrace());
            return fixedupE;
        }
        catch (Exception exception) {
            return e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pushConditional(InternalConditionalOperandType expressionType) {
        try {
            boolean ignore = true;
            try {
                if (this.errorOccurred) {
                    return;
                }
                switch (expressionType.getValue()) {
                    case 2: {
                        ++this.conditionalNesting;
                        break;
                    }
                    case 1: {
                        if (!this.skipTruePart || this.ignoreExpression != CONDITIONAL_IGNORE || this.conditionalIgnoreNestCount != this.conditionalNesting) break;
                        this.ignoreExpression = null;
                        return;
                    }
                    case 0: {
                        int currentNesting = this.conditionalNesting--;
                        if (this.ignoreExpression != CONDITIONAL_IGNORE || this.conditionalIgnoreNestCount != currentNesting) break;
                        this.ignoreExpression = null;
                        return;
                    }
                }
                if (this.ignoreExpression != null) {
                    return;
                }
                ignore = false;
            }
            finally {
                if (this.traceOn) {
                    this.printTrace("Conditional " + expressionType, ignore);
                }
            }
            try {
                switch (expressionType.getValue()) {
                    case 2: {
                        Object condition = this.popExpression();
                        Class type = this.popExpressionType(false);
                        if (type != Boolean.TYPE) {
                            this.throwClassCast(Boolean.TYPE, condition);
                        }
                        if ((Boolean)condition != false) return;
                        this.skipTruePart = true;
                        this.ignoreExpression = CONDITIONAL_IGNORE;
                        this.conditionalIgnoreNestCount = this.conditionalNesting;
                        return;
                    }
                    case 1: {
                        this.skipTruePart = false;
                        this.ignoreExpression = CONDITIONAL_IGNORE;
                        this.conditionalIgnoreNestCount = this.conditionalNesting;
                        return;
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                this.processException(e);
                return;
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
                return;
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushBlockBegin(int blockNumber) {
        if (this.traceOn) {
            this.printTrace("Begin Block #" + blockNumber, this.errorOccurred);
            this.indent(true);
        }
        try {
            if (this.errorOccurred) {
                return;
            }
            if (this.blocks == null) {
                this.blocks = new int[10];
            }
            if (++this.topBlock >= this.blocks.length) {
                int[] newList = new int[this.blocks.length * 2];
                System.arraycopy(this.blocks, 0, newList, 0, this.blocks.length);
                this.blocks = newList;
            }
            this.blocks[this.topBlock] = blockNumber;
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushBlockEnd(int blockNumber) {
        try {
            if (this.traceOn) {
                this.indent(false);
                this.printTrace("End Block #" + blockNumber, this.errorOccurred);
            }
            if (this.errorOccurred) {
                return;
            }
            if (this.blocks == null || this.topBlock < 0 || this.blocks[this.topBlock] != blockNumber) {
                this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushBlockEnd.ReceivedEndBlocksOutOfOrder_EXC_")));
            } else {
                --this.topBlock;
                if (this.ignoreExpression == BLOCK_IGNORE && blockNumber == this.breakBlock) {
                    this.ignoreExpression = null;
                }
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushBlockBreak(int blockNumber) {
        try {
            if (this.traceOn) {
                this.printTrace("Break Block #" + blockNumber, this.errorOccurred);
            }
            if (this.errorOccurred) {
                return;
            }
            if (this.ignoreExpression == null) {
                this.ignoreExpression = BLOCK_IGNORE;
                this.breakBlock = blockNumber;
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushTryBegin(int tryNumber) {
        try {
            if (this.traceOn) {
                this.printTrace("Begin Try #" + tryNumber, this.errorOccurred);
                this.indent(true);
            }
            if (this.errorOccurred) {
                return;
            }
            if (this.trys == null) {
                this.trys = new int[10];
                this.trysInCatch = new Throwable[10];
            }
            if (++this.topTry >= this.trys.length) {
                int[] newList = new int[this.trys.length * 2];
                System.arraycopy(this.trys, 0, newList, 0, this.trys.length);
                this.trys = newList;
                Throwable[] newCatches = new Throwable[this.trys.length];
                System.arraycopy(this.trysInCatch, 0, newCatches, 0, this.trysInCatch.length);
                this.trysInCatch = newCatches;
            }
            this.trys[this.topTry] = tryNumber;
            this.trysInCatch[this.topTry] = null;
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushThrowException() {
        try {
            boolean ignore;
            boolean bl = ignore = this.ignoreExpression != null || this.errorOccurred;
            if (this.traceOn) {
                this.printTrace("Throw exception: ", ignore);
            }
            if (ignore) {
                return;
            }
            try {
                Object t = this.popExpression();
                this.popExpressionType(false);
                if (this.traceOn) {
                    System.out.print(t);
                }
                this.throwException((Throwable)t);
            }
            catch (NoExpressionValueException e) {
                this.processException(e);
            }
            catch (ClassCastException e) {
                this.processException(e);
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    protected final void throwException(Throwable exception) {
        if (this.topTry == -1) {
            if (exception instanceof NoExpressionValueException) {
                this.processSyntaxException((NoExpressionValueException)exception);
            } else {
                this.processSyntaxException(exception);
            }
        } else if (this.trysInCatch[this.topTry] == null) {
            this.ignoreExpression = TRY_THROW_IGNORE;
            this.breakTry = this.trys[this.topTry];
            this.catchThrowable = exception;
        } else {
            this.ignoreExpression = TRY_FINAL_IGNORE;
            this.trysInCatch[this.topTry] = FINAL_CATCH;
            this.breakTry = this.trys[this.topTry];
            this.catchThrowable = exception;
        }
    }

    public final void pushTryCatchClause(int tryNumber, Class exceptionType, InternalExpressionProxy expressionProxy) {
        try {
            if (this.traceOn) {
                this.indent(false);
                if (expressionProxy == null) {
                    this.printTrace("Catch Try #" + tryNumber + " (" + exceptionType + ')', this.errorOccurred);
                } else {
                    this.printTrace("Catch Try #" + tryNumber + " (" + exceptionType + ") Return exception in proxy #" + expressionProxy.getProxyID(), this.errorOccurred);
                }
                this.indent(true);
            }
            if (this.errorOccurred) {
                return;
            }
            if (this.trys == null || this.topTry < 0 || this.trys[this.topTry] != tryNumber) {
                this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushTryCatchClause.CatchReceivedOutOfOrder_EXC_")));
            } else if (this.ignoreExpression == null) {
                this.ignoreExpression = TRY_FINAL_IGNORE;
                this.breakTry = tryNumber;
            } else if (this.ignoreExpression == TRY_THROW_IGNORE && tryNumber == this.breakTry && exceptionType.isInstance(this.catchThrowable)) {
                this.ignoreExpression = null;
                this.trysInCatch[this.topTry] = this.catchThrowable;
                this.breakTry = -1;
                if (expressionProxy != null) {
                    expressionProxy.setProxy(this.catchThrowable, this.catchThrowable.getClass());
                    this.allocateExpressionProxy(expressionProxy);
                }
                if (this.traceOn) {
                    System.out.print(" Caught: ");
                    System.out.print(this.catchThrowable);
                }
                this.catchThrowable = null;
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushTryFinallyClause(int tryNumber) {
        try {
            if (this.traceOn) {
                this.indent(false);
                this.printTrace("Finally Try #" + tryNumber, this.errorOccurred);
                this.indent(true);
            }
            if (this.errorOccurred) {
                return;
            }
            if (this.trys == null || this.topTry < 0 || this.trys[this.topTry] != tryNumber) {
                this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushTryFinallyClause.FinallyReceivedOutOfOrder_EXC_")));
            } else if (tryNumber == this.breakTry && (this.ignoreExpression == TRY_THROW_IGNORE || this.ignoreExpression == TRY_FINAL_IGNORE)) {
                this.ignoreExpression = null;
                this.trysInCatch[this.topTry] = FINAL_CATCH;
                this.breakTry = -1;
                if (this.traceOn) {
                    System.out.print(" Executing finally.");
                }
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushTryRethrow(int tryNumber) {
        if (this.traceOn) {
            this.printTrace("Rethrow Try #" + tryNumber, this.errorOccurred || this.ignoreExpression != null);
        }
        try {
            if (this.errorOccurred) {
                return;
            }
            if (this.trys == null || this.topTry < 0 || this.trys[this.topTry] != tryNumber) {
                this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushTryRethrow.RethrowReceivedOutOfOrder_EXC_")));
            } else if (this.ignoreExpression == null) {
                if (this.trysInCatch[this.topTry] == null || this.trysInCatch[this.topTry] == FINAL_CATCH) {
                    this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushTryRethrow.RetryReceivedOutOfExecutingCatchClause_EXC_")));
                } else {
                    this.throwException(this.trysInCatch[this.topTry]);
                }
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushTryEnd(int tryNumber) {
        if (this.traceOn) {
            this.indent(false);
            this.printTrace("End Try #" + tryNumber, this.errorOccurred);
        }
        try {
            if (this.errorOccurred) {
                return;
            }
            if (this.trys == null || this.topTry < 0 || this.trys[this.topTry] != tryNumber) {
                this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushTryEnd.TryEndReceivedOutOfOrder_EXC_")));
            } else {
                boolean inCatch = this.trysInCatch[this.topTry] != null;
                this.trysInCatch[this.topTry] = null;
                --this.topTry;
                if (inCatch || tryNumber == this.breakTry && (this.ignoreExpression == TRY_THROW_IGNORE || this.ignoreExpression == TRY_FINAL_IGNORE)) {
                    this.ignoreExpression = null;
                    this.breakTry = -1;
                    if (this.catchThrowable != null) {
                        this.throwException(this.catchThrowable);
                    }
                }
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    protected SaveState createSaveState(int markID) {
        return new SaveState(markID);
    }

    public final void pushMark(int markNumber) {
        if (this.traceOn) {
            this.printTrace("Mark#" + markNumber, false);
        }
        if (this.saveStates == null) {
            this.saveStates = new ArrayList();
        }
        this.saveStates.add(this.createSaveState(markNumber));
        if (this.traceOn) {
            this.printTraceEnd();
        }
    }

    public final void pushEndmark(int markID, boolean restore) {
        if (this.traceOn) {
            this.printTrace("End Mark#" + markID + " Restored=" + restore, false);
        }
        try {
            if (this.saveStates != null) {
                int i = this.saveStates.size() - 1;
                while (i >= 0) {
                    SaveState state = (SaveState)this.saveStates.remove(i);
                    if (state.markID == markID) {
                        if (restore) {
                            state.restoreState();
                        }
                        return;
                    }
                    --i;
                }
                this.processSyntaxException(new IllegalStateException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.PushEndmark.EndMarkOnNonExistingID_EXC_"), new Integer(markID))));
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushSubexpressionBegin(int subexpressionNumber) {
        if (this.traceOn) {
            this.printTrace("Begin Subexpression #" + subexpressionNumber, this.errorOccurred);
            this.indent(true);
        }
        try {
            if (this.errorOccurred) {
                return;
            }
            if (this.subexpressions == null) {
                this.subexpressions = new int[10];
                this.subexpressionStackPos = new int[10];
            }
            if (++this.topSubexpression >= this.subexpressions.length) {
                int[] newList = new int[this.subexpressions.length * 2];
                System.arraycopy(this.subexpressions, 0, newList, 0, this.subexpressions.length);
                this.subexpressions = newList;
                newList = new int[this.subexpressionStackPos.length * 2];
                System.arraycopy(this.subexpressionStackPos, 0, newList, 0, this.subexpressionStackPos.length);
                this.subexpressionStackPos = newList;
            }
            this.subexpressions[this.topSubexpression] = subexpressionNumber;
            this.subexpressionStackPos[this.topSubexpression] = this.expressionStack.size();
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    public final void pushSubexpressionEnd(int subexpressionNumber) {
        try {
            if (this.traceOn) {
                this.indent(false);
                this.printTrace("End Subexpression #" + subexpressionNumber, this.errorOccurred);
            }
            if (this.errorOccurred) {
                return;
            }
            if (this.subexpressions == null || this.topSubexpression < 0 || this.subexpressions[this.topSubexpression] != subexpressionNumber) {
                this.processSyntaxException(new IllegalStateException(InitparserTreeMessages.getString("ExpressionProcesser.PushSubexpressionEnd.ReceivedEndSubexpressionsOutOfOrder_EXC_")));
            } else {
                try {
                    this.popExpressions(this.expressionStack.size() - this.subexpressionStackPos[this.topSubexpression]);
                    --this.topSubexpression;
                }
                catch (NoExpressionValueException e) {
                    this.processException(e);
                }
            }
        }
        finally {
            if (this.traceOn) {
                this.printTraceEnd();
            }
        }
    }

    protected static class ArrayAccessReference
    extends VariableReference {
        private final Object array;
        private final int index;

        public static ArrayAccessReference createArrayAccessReference(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
            int len = Array.getLength(array);
            if (index < 0 || len <= index) {
                throw new ArrayIndexOutOfBoundsException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CreateArrayAccessReference.OutOfBounds_EXC_"), new Integer(index), new Integer(len)));
            }
            return new ArrayAccessReference(array, index);
        }

        protected ArrayAccessReference(Object array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public Object dereference() {
            return Array.get(this.array, this.index);
        }

        @Override
        public Object set(Object value, Class type) throws IllegalArgumentException {
            Array.set(this.array, this.index, value);
            return Array.get(this.array, this.index);
        }

        public String toString() {
            return "ArrayAccess[" + this.index + "]: " + this.array.toString();
        }
    }

    protected static class FieldAccessReference
    extends VariableReference {
        private final Field field;
        private final Object receiver;

        public static FieldAccessReference createFieldAccessReference(Field field, Object receiver) throws IllegalArgumentException {
            if (!Modifier.isStatic(field.getModifiers()) && !field.getDeclaringClass().isInstance(receiver)) {
                throw new IllegalArgumentException(MessageFormat.format(InitparserTreeMessages.getString("ExpressionProcesser.CreateFieldAccessReference.FieldsTypesNotMatching_EXC_"), field.getType(), receiver != null ? receiver.getClass() : null));
            }
            field.setAccessible(true);
            return new FieldAccessReference(field, receiver);
        }

        protected FieldAccessReference(Field field, Object receiver) {
            this.field = field;
            this.receiver = receiver;
        }

        @Override
        public Object dereference() {
            try {
                return this.field.get(this.receiver);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public Object set(Object value, Class type) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(this.receiver, value);
            return this.field.get(this.receiver);
        }

        public String toString() {
            return "FieldAccess{" + this.field.toString() + "} on " + (this.receiver != null ? this.receiver.toString() : "<static access>");
        }
    }

    protected class SaveState {
        public int markID;
        public int topBlock;
        public int breakBlock;
        public int topSubexpression;
        public int topTry;
        public int breakTry;
        public Throwable catchThrowable;
        public boolean errorOccurred;
        public boolean novalueException;
        public Throwable exception;
        public Object ignoreExpression;
        public int expressionStackPos;
        public int ifElseNesting;
        public int ifElseIgnoreNestCount;
        public boolean ifElseSkipTruePart;
        public int indent;
        public int expressionProxyPos;

        public SaveState(int markID) {
            this.markID = markID;
            ExpressionProcesser ep = ExpressionProcesser.this;
            this.topBlock = ep.topBlock;
            this.breakBlock = ep.breakBlock;
            this.topSubexpression = ep.topSubexpression;
            this.topTry = ep.topTry;
            this.breakTry = ep.breakTry;
            this.catchThrowable = ep.catchThrowable;
            this.errorOccurred = ep.errorOccurred;
            this.novalueException = ep.novalueException;
            this.exception = ep.exception;
            this.ignoreExpression = ep.ignoreExpression;
            this.expressionStackPos = ExpressionProcesser.this.expressionStack.size() - 1;
            this.ifElseNesting = ep.ifElseNesting;
            this.ifElseIgnoreNestCount = ep.ifElseIgnoreNestCount;
            this.ifElseSkipTruePart = ep.ifElseSkipTruePart;
            this.indent = ep.indent;
            this.expressionProxyPos = ExpressionProcesser.this.expressionProxies != null ? ExpressionProcesser.this.expressionProxies.size() - 1 : -1;
        }

        public void restoreState() {
            int i;
            ExpressionProcesser ep = ExpressionProcesser.this;
            ep.topBlock = this.topBlock;
            ep.breakBlock = this.breakBlock;
            ep.topSubexpression = this.topSubexpression;
            ep.topTry = this.topTry;
            ep.breakTry = this.breakTry;
            ep.catchThrowable = this.catchThrowable;
            if (ExpressionProcesser.this.trysInCatch != null) {
                i = this.topTry + 1;
                while (i < ep.trysInCatch.length) {
                    ((ExpressionProcesser)ep).trysInCatch[i] = null;
                    ++i;
                }
            }
            ep.errorOccurred = this.errorOccurred;
            ep.novalueException = ep.novalueException;
            ep.exception = this.exception;
            ep.ignoreExpression = this.ignoreExpression;
            i = ExpressionProcesser.this.expressionStack.size() - 1;
            while (i > this.expressionStackPos) {
                ExpressionProcesser.this.expressionStack.remove(i);
                ExpressionProcesser.this.expressionTypeStack.remove(i);
                --i;
            }
            ep.ifElseNesting = this.ifElseNesting;
            ep.ifElseIgnoreNestCount = this.ifElseIgnoreNestCount;
            ep.ifElseSkipTruePart = this.ifElseSkipTruePart;
            ep.indent = this.indent;
            if (ExpressionProcesser.this.expressionProxies != null) {
                i = ExpressionProcesser.this.expressionProxies.size() - 1;
                while (i > this.expressionProxyPos) {
                    ExpressionProcesser.this.expressionProxies.remove(i);
                    --i;
                }
            }
            ep.conditionalIgnoreNestCount = 0;
            ep.conditionalNesting = 0;
            ep.skipTruePart = false;
            ep.infixIgnoreNestCount = 0;
            ep.infixNesting = 0;
        }
    }
}

