/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.eclipse;

import org.eclipse.wst.command.internal.env.core.CommandManager;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.uri.IURIFactory;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.SimpleURIFactory;

public class EclipseEnvironment
implements BaseEclipseEnvironment {
    private CommandManager commandManager_ = null;
    private SimpleURIFactory uriFactory_ = null;
    private ResourceContext resourceContext_ = null;
    private IStatusHandler statusHandler_ = null;
    private ILog logger_ = null;

    public EclipseEnvironment(CommandManager commandManager, ResourceContext resourceContext, IStatusHandler statusHandler) {
        IURIScheme eclipseScheme = EnvironmentService.getEclipseScheme();
        IURIScheme fileScheme = EnvironmentService.getFileScheme();
        this.commandManager_ = commandManager;
        this.resourceContext_ = resourceContext;
        this.uriFactory_ = new SimpleURIFactory();
        this.statusHandler_ = statusHandler;
        this.uriFactory_.registerScheme("platform", eclipseScheme);
        this.uriFactory_.registerScheme("file", fileScheme);
    }

    public CommandManager getCommandManager() {
        return this.commandManager_;
    }

    public ILog getLog() {
        if (this.logger_ == null) {
            this.logger_ = EnvironmentService.getEclipseLog();
        }
        return this.logger_;
    }

    public void setLog(ILog logger) {
        this.logger_ = logger;
    }

    public IStatusHandler getStatusHandler() {
        return this.statusHandler_;
    }

    public IURIFactory getURIFactory() {
        return this.uriFactory_;
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext_;
    }

    public void setCommandManager(CommandManager manager) {
        this.commandManager_ = manager;
    }
}

