/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class Util {
    public static final String UTF_8 = "UTF-8";
    public static final String SRC_SCRIPTS_CONTAINER = "scripts";
    private static final int DEFAULT_READING_SIZE = 8192;

    public static int numberAsInt(Object number) {
        return ((Number)number).intValue();
    }

    public static IPath getPluginDirectoryPath() {
        if (Platform.isRunning()) {
            try {
                URL platformURL = Platform.getBundle((String)"org.eclipse.wst.jsdt.debug.rhino.tests").getEntry("/");
                return new Path(new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Path(System.getProperty("user.dir"));
    }

    public static String getTestSource(String container, String sourcename) throws IOException {
        URL platformURL;
        char[] chars;
        if (Platform.isRunning() && (chars = Util.getInputStreamAsCharArray((platformURL = Platform.getBundle((String)"org.eclipse.wst.jsdt.debug.rhino.tests").getEntry("/" + container + "/" + sourcename)).openStream(), -1, UTF_8)) != null) {
            return new String(chars);
        }
        throw new IllegalStateException("Platform not running");
    }

    public static String getFileContentAsString(File file) {
        String contents;
        block14: {
            contents = null;
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(file);
                    char[] array = Util.getInputStreamAsCharArray(stream, -1, UTF_8);
                    contents = new String(array);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        Charset charset = null;
        try {
            charset = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : " + encoding);
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : " + encoding);
            return null;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] contents = Util.getInputStreamAsByteArray(stream, length);
        ByteBuffer byteBuffer = ByteBuffer.allocate(contents.length);
        byteBuffer.put(contents);
        byteBuffer.flip();
        return charsetDecoder.decode(byteBuffer).array();
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }
}

