/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.ASDCCombo;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.TypeReferenceDirectEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.InterfaceEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.BaseLinkIconFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ModelDiagnosticInfo;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.RowLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;

public class ParameterTypeEditPart
extends BaseEditPart
implements IFeedbackHandler,
INamedEditPart {
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();
    protected Label parameterType;
    protected RowLayout rowLayout = new RowLayout();
    protected MyMouseEventListener mouseEventListener;
    private BaseLinkIconFigure linkIconFigure;
    private EditPartListener editPartListener;

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit(null);
        }
        if (req.getType().equals("open")) {
            this.showPreviewDialog(null);
        }
    }

    protected IFigure createFigure() {
        Panel figure = new Panel(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Rectangle r = this.getBounds();
                ParameterTypeEditPart.this.paintFocusCursor(new Rectangle(r.x, r.y, r.width, r.height), graphics);
            }
        };
        figure.setLayoutManager((LayoutManager)this.rowLayout);
        this.parameterType = new Label();
        this.parameterType.setLabelAlignment(1);
        this.parameterType.setBorder((Border)new MarginBorder(4, 12, 4, 20));
        figure.add((IFigure)this.parameterType);
        if (this.isReadOnly()) {
            this.parameterType.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.parameterType.setForegroundColor(DesignViewGraphicsConstants.defaultForegroundColor);
        }
        return figure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IParameter param = (IParameter)this.getModel();
        String name = param.getComponentName();
        this.parameterType.setText(name);
        Image image = ((ITreeElement)this.getModel()).getSecondaryImage();
        if (image != null) {
            this.parameterType.setIcon(image);
        }
        this.parameterType.setForegroundColor(DesignViewGraphicsConstants.defaultForegroundColor);
        List diagnosticMessages = param.getDiagnosticMessages();
        Iterator it = diagnosticMessages.iterator();
        ModelDiagnosticInfo errorInfo = null;
        while (it.hasNext() && errorInfo == null) {
            ModelDiagnosticInfo temp = (ModelDiagnosticInfo)it.next();
            if (temp.getType() != ModelDiagnosticInfo.ERROR_TYPE) continue;
            errorInfo = temp;
            break;
        }
        if (errorInfo != null) {
            this.parameterType.setText(errorInfo.getDescriptionText());
            this.parameterType.setForegroundColor(errorInfo.getDescriptionTextColor());
            this.parameterType.setIcon(null);
        }
        if (this.getInterfaceEditPart() != null) {
            ((Figure)this.getInterfaceEditPart().getLinkIconColumn()).invalidate();
            this.refreshLinkFigure(new Point(-1, -1));
        }
    }

    private InterfaceEditPart getInterfaceEditPart() {
        EditPart ep = this.getParent();
        while (ep != null && !(ep instanceof InterfaceEditPart)) {
            ep = ep.getParent();
        }
        if (ep instanceof InterfaceEditPart) {
            return (InterfaceEditPart)ep;
        }
        return null;
    }

    @Override
    public void addFeedback() {
        this.figure.setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
    }

    @Override
    public void removeFeedback() {
        this.figure.setBackgroundColor(this.figure.getParent().getBackgroundColor());
    }

    @Override
    public Label getLabelFigure() {
        return this.parameterType;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    @Override
    public void performDirectEdit(Point cursorLocation) {
        if (!this.isFileReadOnly() && (cursorLocation == null || this.hitTest(this.parameterType, cursorLocation) && !this.isReadOnly())) {
            IParameter param = (IParameter)this.getModel();
            TypeReferenceDirectEditManager manager = new TypeReferenceDirectEditManager(param, this, this.parameterType);
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        } else if (this.parameterType.getParent() instanceof Figure && this.hitTestFigure((Figure)this.parameterType.getParent(), cursorLocation) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    @Override
    public void activate() {
        super.activate();
        IFigure primaryLayer = this.getLayer("Primary Layer");
        this.mouseEventListener = new MyMouseEventListener();
        primaryLayer.addMouseMotionListener((MouseMotionListener)this.mouseEventListener);
        primaryLayer.addMouseListener((MouseListener)this.mouseEventListener);
        this.editPartListener = new EditPartListener(){

            public void childAdded(EditPart child, int index) {
            }

            public void partActivated(EditPart editpart) {
            }

            public void partDeactivated(EditPart editpart) {
            }

            public void removingChild(EditPart child, int index) {
            }

            public void selectedStateChanged(EditPart editpart) {
                IOpenExternalEditorHelper openHelper = ParameterTypeEditPart.this.getExternalEditorOpener();
                if (openHelper != null && openHelper.linkApplicable()) {
                    if (!ParameterTypeEditPart.this.figureContainsLinkFigure(ParameterTypeEditPart.this.getInterfaceEditPart().getLinkIconColumn())) {
                        ParameterTypeEditPart.this.linkIconFigure = new BaseLinkIconFigure(ParameterTypeEditPart.this);
                        ParameterTypeEditPart.this.getInterfaceEditPart().getLinkIconColumn().add((IFigure)ParameterTypeEditPart.this.linkIconFigure);
                    }
                    if (openHelper.isValid()) {
                        ParameterTypeEditPart.this.linkIconFigure.setLinkIconStyle(BaseLinkIconFigure.VALID_SCHEMA_LINK_STYLE);
                        if (editpart.getSelected() == 0) {
                            ParameterTypeEditPart.this.unemphasizeLinkFigure();
                        } else {
                            ParameterTypeEditPart.this.emphasizeLinkFigure();
                        }
                    } else {
                        ParameterTypeEditPart.this.linkIconFigure.setLinkIconStyle(BaseLinkIconFigure.INVALID_SCHEMA_LINK_STYLE);
                    }
                } else if (ParameterTypeEditPart.this.containsLinkFigure()) {
                    ParameterTypeEditPart.this.getInterfaceEditPart().getLinkIconColumn().remove((IFigure)ParameterTypeEditPart.this.linkIconFigure);
                }
            }
        };
        this.addEditPartListener(this.editPartListener);
    }

    @Override
    public void deactivate() {
        IFigure fig;
        InterfaceEditPart ep;
        if (this.mouseEventListener != null) {
            IFigure primaryLayer = this.getLayer("Primary Layer");
            primaryLayer.removeMouseMotionListener((MouseMotionListener)this.mouseEventListener);
            primaryLayer.removeMouseListener((MouseListener)this.mouseEventListener);
        }
        if (this.editPartListener != null) {
            this.removeEditPartListener(this.editPartListener);
        }
        if ((ep = this.getInterfaceEditPart()) != null && this.linkIconFigure != null && (fig = ep.getLinkIconColumn()).getChildren().contains((Object)this.linkIconFigure)) {
            ep.getLinkIconColumn().remove((IFigure)this.linkIconFigure);
        }
    }

    @Override
    public EditPart getRelativeEditPart(int direction) {
        EditPart editPart = super.getRelativeEditPart(direction);
        if (direction == 4 && (editPart == null || editPart == this)) {
            editPart = EditPartNavigationHandlerUtil.getNextInterface((EditPart)this);
        }
        return editPart;
    }

    private void showPreviewDialog(Point point) {
        Rectangle linkFigBounds = this.getLinkFigureBounds();
        if (linkFigBounds == null) {
            return;
        }
        Rectangle testbounds = new Rectangle(linkFigBounds.x, linkFigBounds.y, 0, linkFigBounds.height);
        if (this.pointerInRange(testbounds, point)) {
            IOpenExternalEditorHelper helper = this.getExternalEditorOpener();
            helper.showPreview();
        }
    }

    private void emphasizeLinkFigure() {
        this.linkIconFigure.setColor(ColorConstants.blue);
    }

    private void unemphasizeLinkFigure() {
        this.linkIconFigure.setColor(ColorConstants.lightGray);
    }

    private boolean pointerInRange(Rectangle figBounds, Point pointer) {
        if (pointer == null) {
            return true;
        }
        Rectangle linkBounds = this.getLinkFigureBounds();
        int entireX = figBounds.x;
        int entireY = figBounds.y;
        int entireWidth = figBounds.width + linkBounds.width;
        int entireHeight = figBounds.height;
        Rectangle entireBounds = new Rectangle(entireX, entireY, entireWidth, entireHeight);
        return entireBounds.contains(pointer);
    }

    private boolean containsLinkFigure() {
        for (Object item : this.getInterfaceEditPart().getLinkIconColumn().getChildren()) {
            if (!item.equals((Object)this.linkIconFigure)) continue;
            return true;
        }
        return false;
    }

    private Rectangle getLinkFigureBounds() {
        if (this.containsLinkFigure()) {
            return this.linkIconFigure.getBounds();
        }
        return null;
    }

    private IOpenExternalEditorHelper getExternalEditorOpener() {
        Object adapted;
        IWorkbenchPage page;
        IOpenExternalEditorHelper openExternalEditorHelper = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActiveEditor() != null && (adapted = page.getActiveEditor().getAdapter(IOpenExternalEditorHelper.class)) instanceof IOpenExternalEditorHelper) {
            openExternalEditorHelper = (IOpenExternalEditorHelper)adapted;
            openExternalEditorHelper.setModel(this.getModel());
        }
        return openExternalEditorHelper;
    }

    private void refreshLinkFigure(Point point) {
        Rectangle figBounds = this.getFigure().getParent().getParent().getBounds();
        IOpenExternalEditorHelper openHelper = this.getExternalEditorOpener();
        if (openHelper != null && openHelper.linkApplicable()) {
            if (!this.figureContainsLinkFigure(this.getInterfaceEditPart().getLinkIconColumn())) {
                this.linkIconFigure = new BaseLinkIconFigure(this);
                this.getInterfaceEditPart().getLinkIconColumn().add((IFigure)this.linkIconFigure);
            }
            if (openHelper.isValid()) {
                this.linkIconFigure.setLinkIconStyle(BaseLinkIconFigure.VALID_SCHEMA_LINK_STYLE);
                if (this.pointerInRange(figBounds, point)) {
                    this.emphasizeLinkFigure();
                } else {
                    this.unemphasizeLinkFigure();
                }
            } else {
                this.linkIconFigure.setLinkIconStyle(BaseLinkIconFigure.INVALID_SCHEMA_LINK_STYLE);
            }
        } else if (this.containsLinkFigure()) {
            this.getInterfaceEditPart().getLinkIconColumn().remove((IFigure)this.linkIconFigure);
        }
    }

    private boolean figureContainsLinkFigure(IFigure parent) {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            if (!it.next().equals((Object)this.linkIconFigure)) continue;
            return true;
        }
        return false;
    }

    private void openExternalEditor(Point point) {
        Rectangle linkFigBounds = this.getLinkFigureBounds();
        if (linkFigBounds == null || this.getExternalEditorOpener() == null) {
            return;
        }
        Rectangle testbounds = new Rectangle(linkFigBounds.x, linkFigBounds.y, 0, linkFigBounds.height);
        if (this.getExternalEditorOpener().linkApplicable() && this.pointerInRange(testbounds, point)) {
            this.getExternalEditorOpener().openExternalEditor();
        }
    }

    @Override
    protected String getAccessibleName() {
        Label labelFigure = this.getLabelFigure();
        if (labelFigure != null) {
            return labelFigure.getText();
        }
        return "";
    }

    private class MyMouseEventListener
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MyMouseEventListener() {
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            Point pointer = me.getLocation();
            ParameterTypeEditPart.this.refreshLinkFigure(pointer);
        }

        public void mousePressed(MouseEvent me) {
            Point pointer = me.getLocation();
            ParameterTypeEditPart.this.openExternalEditor(pointer);
        }

        public void mouseHover(MouseEvent me) {
            Point pointer = me.getLocation();
            ParameterTypeEditPart.this.showPreviewDialog(pointer);
        }
    }

    private class SimpleDirectEditPolicy
    extends DirectEditPolicy {
        protected TypeReferenceDirectEditManager delegate;

        private SimpleDirectEditPolicy() {
        }

        public void setDelegate(TypeReferenceDirectEditManager delegate) {
            this.delegate = delegate;
        }

        protected Command getDirectEditCommand(final DirectEditRequest request) {
            return new Command(){

                public void execute() {
                    if (SimpleDirectEditPolicy.this.delegate != null) {
                        SimpleDirectEditPolicy.this.delegate.performEdit(request.getCellEditor());
                    }
                }

                public void redo() {
                }

                public void undo() {
                }

                public boolean canExecute() {
                    IParameter parameter = (IParameter)ParameterTypeEditPart.this.getModel();
                    String newValue = ((ASDCCombo)request.getCellEditor().getControl()).getText();
                    if (newValue instanceof String) {
                        return !newValue.equals(parameter.getComponentName());
                    }
                    return true;
                }
            };
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            this.getHostFigure().getUpdateManager().performUpdate();
        }
    }
}

