/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11ParameterForAttribute;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11ParameterForElement;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11ParameterForPart;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;

public class W11ReorderParametersCommand
extends W11TopLevelElementCommand {
    protected IParameter leftSibling;
    protected IParameter rightSibling;
    protected IParameter movingParameter;

    public W11ReorderParametersCommand(IParameter leftSibling, IParameter rightSibling, IParameter movingParameter) {
        super(Messages._UI_ACTION_REORDER_PART, null);
        this.leftSibling = leftSibling;
        this.rightSibling = rightSibling;
        this.movingParameter = movingParameter;
    }

    @Override
    public void execute() {
        if (this.leftSibling instanceof W11ParameterForPart || this.rightSibling instanceof W11ParameterForPart || this.movingParameter instanceof W11ParameterForPart) {
            this.executeForPart();
        } else if (this.leftSibling instanceof W11ParameterForElement || this.rightSibling instanceof W11ParameterForElement || this.movingParameter instanceof W11ParameterForElement) {
            this.executeForElement();
        } else if (!(this.leftSibling instanceof W11ParameterForAttribute) && !(this.rightSibling instanceof W11ParameterForAttribute)) {
            boolean cfr_ignored_0 = this.movingParameter instanceof W11ParameterForAttribute;
        }
    }

    private void executeForElement() {
        XSDElementDeclaration leftSibElement = null;
        XSDElementDeclaration rightSibElement = null;
        Object movingChild = null;
        XSDParticle movingParticle = null;
        XSDParticle leftParticle = null;
        XSDParticle rightParticle = null;
        if (this.leftSibling instanceof W11ParameterForElement) {
            leftSibElement = (XSDElementDeclaration)((W11ParameterForElement)this.leftSibling).getTarget();
            leftParticle = (XSDParticle)leftSibElement.eContainer();
        }
        if (this.rightSibling instanceof W11ParameterForElement) {
            rightSibElement = (XSDElementDeclaration)((W11ParameterForElement)this.rightSibling).getTarget();
            rightParticle = (XSDParticle)rightSibElement.eContainer();
        }
        if (this.movingParameter instanceof W11ParameterForElement) {
            movingChild = (XSDElementDeclaration)((W11ParameterForElement)this.movingParameter).getTarget();
            movingParticle = (XSDParticle)movingChild.eContainer();
        }
        if (movingChild.equals(leftSibElement) || movingChild.equals(rightSibElement)) {
            return;
        }
        if (movingChild != null) {
            try {
                this.beginRecording(movingParticle.getElement());
                XSDModelGroup container = (XSDModelGroup)movingParticle.getContainer();
                EList particles = container.getContents();
                particles.remove(movingParticle);
                int leftIndex = -1;
                int rightIndex = -1;
                if (leftParticle != null) {
                    leftIndex = particles.indexOf(leftParticle);
                }
                if (rightParticle != null) {
                    rightIndex = particles.indexOf(rightParticle);
                }
                if (leftIndex == -1) {
                    particles.add(0, movingParticle);
                } else if (rightIndex == -1) {
                    particles.add(movingParticle);
                } else {
                    particles.add(leftIndex + 1, movingParticle);
                }
            }
            finally {
                this.endRecording(movingParticle.getElement());
            }
        }
    }

    private void executeForPart() {
        Part leftSibElement = null;
        Part rightSibElement = null;
        Object movingChild = null;
        if (this.leftSibling instanceof W11ParameterForPart) {
            leftSibElement = (Part)((W11ParameterForPart)this.leftSibling).getTarget();
        }
        if (this.rightSibling instanceof W11ParameterForPart) {
            rightSibElement = (Part)((W11ParameterForPart)this.rightSibling).getTarget();
        }
        if (this.movingParameter instanceof W11ParameterForPart) {
            movingChild = (Part)((W11ParameterForPart)this.movingParameter).getTarget();
        }
        if (movingChild.equals(leftSibElement) || movingChild.equals(rightSibElement)) {
            return;
        }
        if (movingChild != null) {
            try {
                this.beginRecording(movingChild.getElement());
                Message message = (Message)movingChild.eContainer();
                EList parts = message.getEParts();
                parts.remove(movingChild);
                int leftIndex = -1;
                int rightIndex = -1;
                if (leftSibElement != null) {
                    leftIndex = parts.indexOf(leftSibElement);
                }
                if (rightSibElement != null) {
                    rightIndex = parts.indexOf(rightSibElement);
                }
                if (leftIndex == -1) {
                    parts.add(0, movingChild);
                } else if (rightIndex == -1) {
                    parts.add(movingChild);
                } else {
                    parts.add(leftIndex + 1, movingChild);
                }
            }
            finally {
                this.endRecording(movingChild.getElement());
            }
        }
    }
}

