/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query;

import java.util.Collections;
import java.util.List;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultSet<T>
implements IResultSet<T> {
    private List _results;
    private boolean _isClosed = false;

    @Override
    public List<T> getResults() throws MetaDataException {
        this.initIfNecessary();
        return this._results;
    }

    @Override
    public final void close() throws MetaDataException {
        this.doClose();
        this._isClosed = true;
        this._results = null;
    }

    protected void doClose() throws MetaDataException {
    }

    @Override
    public final boolean isClosed() {
        return this._isClosed;
    }

    protected abstract List<T> getInternalResults();

    private void initIfNecessary() throws MetaDataException {
        if (this._isClosed) {
            throw new MetaDataException("Attempt to access a closed resultset.");
        }
        if (this._results == null) {
            List checkNullResults = this.getInternalResults();
            if (checkNullResults == null) {
                checkNullResults = Collections.EMPTY_LIST;
            }
            this._results = Collections.unmodifiableList(checkNullResults);
        }
    }
}

