/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogger;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogging;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class EclipseLinkLoggerClassChooser
extends ClassChooserComboPane<EclipseLinkLogging> {
    public EclipseLinkLoggerClassChooser(Pane<? extends EclipseLinkLogging> parentPane, Composite parent, Hyperlink hyperlink) {
        super(parentPane, parent, hyperlink);
    }

    protected String getClassName() {
        if (((EclipseLinkLogging)this.getSubject()).getLogger() == null) {
            return EclipseLinkLogger.default_logger.getClassName();
        }
        return EclipseLinkLogger.getLoggerClassName((String)((EclipseLinkLogging)this.getSubject()).getLogger());
    }

    protected IJavaProject getJavaProject() {
        return ((EclipseLinkLogging)this.getSubject()).getJpaProject().getJavaProject();
    }

    protected String getSuperInterfaceName() {
        return "org.eclipse.persistence.logging.SessionLog";
    }

    protected ModifiablePropertyValueModel<String> buildTextHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, String>(this.getSubjectHolder(), new String[]{"logger"}){

            protected String buildValue_() {
                String name = ((EclipseLinkLogging)this.subject).getLogger();
                if (name == null) {
                    name = EclipseLinkLoggerClassChooser.this.getDefaultValue((EclipseLinkLogging)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (EclipseLinkLoggerClassChooser.this.getDefaultValue((EclipseLinkLogging)this.subject).equals(value)) {
                    value = null;
                }
                ((EclipseLinkLogging)this.subject).setLogger(value);
            }
        };
    }

    private PropertyValueModel<String> buildDefaultLoggerHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, String>(this.getSubjectHolder(), new String[]{EclipseLinkLogging.DEFAULT_LOGGER}){

            protected String buildValue_() {
                return EclipseLinkLoggerClassChooser.this.getDefaultValue((EclipseLinkLogging)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultLoggerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultLoggerHolder());
    }

    String buildDisplayString(String loggerName) {
        switch (EclipseLinkLogger.valueOf((String)loggerName)) {
            case default_logger: {
                return JptJpaEclipseLinkUiMessages.LOGGER_COMPOSITE_DEFAULT_LOGGER;
            }
            case java_logger: {
                return JptJpaEclipseLinkUiMessages.LOGGER_COMPOSITE_JAVA_LOGGER;
            }
            case server_logger: {
                return JptJpaEclipseLinkUiMessages.LOGGER_COMPOSITE_SERVER_LOGGER;
            }
        }
        return null;
    }

    private Comparator<String> buildLoggerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String logger1, String logger2) {
                logger1 = EclipseLinkLoggerClassChooser.this.buildDisplayString(logger1);
                logger2 = EclipseLinkLoggerClassChooser.this.buildDisplayString(logger2);
                return Collator.getInstance().compare(logger1, logger2);
            }
        };
    }

    protected Transformer<String, String> buildClassConverter() {
        return new ClassTransformer();
    }

    protected ListValueModel<String> buildClassListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultLoggerListHolder());
        holders.add(this.buildLoggersListHolder());
        return CompositeListValueModel.forModels(holders);
    }

    private Iterator<String> buildLoggers() {
        return IteratorTools.transform((Iterator)IteratorTools.iterator((Object[])EclipseLinkLogger.values()), (Transformer)PersistenceXmlEnumValue.ENUM_NAME_TRANSFORMER);
    }

    private CollectionValueModel<String> buildLoggersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.hashBag(this.buildLoggers()));
    }

    private ListValueModel<String> buildLoggersListHolder() {
        return new SortedListValueModelAdapter(this.buildLoggersCollectionHolder(), this.buildLoggerComparator());
    }

    private String getDefaultValue(EclipseLinkLogging subject) {
        String defaultValue = subject.getDefaultLogger();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    protected void setClassName(String className) {
        ((EclipseLinkLogging)this.getSubject()).setLogger(className);
    }

    class ClassTransformer
    extends TransformerAdapter<String, String> {
        ClassTransformer() {
        }

        public String transform(String value) {
            try {
                return EclipseLinkLoggerClassChooser.this.buildDisplayString(value);
            }
            catch (RuntimeException runtimeException) {
                return value;
            }
        }
    }
}

