/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.widgets;

import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;

public final class ComboTools {
    public static void handleDefaultValue(Combo combo) {
        ComboListener listener = new ComboListener();
        combo.addFocusListener((FocusListener)listener);
        combo.addModifyListener((ModifyListener)listener);
    }

    static class ComboListener
    implements FocusListener,
    ModifyListener {
        ComboListener() {
        }

        public void focusGained(FocusEvent e) {
            Combo combo = (Combo)e.widget;
            if (combo.getSelectionIndex() == 0) {
                DisplayTools.asyncExec(new SelectText(combo));
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            Combo combo = (Combo)e.widget;
            if (combo.isFocusControl() && combo.getSelectionIndex() == 0) {
                DisplayTools.asyncExec(new ModifyText(combo));
            }
        }

        private class ModifyText
        implements Runnable {
            private final Combo combo;

            ModifyText(Combo combo) {
                this.combo = combo;
            }

            @Override
            public void run() {
                if (this.combo.isDisposed()) {
                    return;
                }
                String text = this.combo.getText();
                if (text.length() == 0) {
                    text = this.combo.getItem(0);
                    this.combo.setText(text);
                }
                this.combo.setSelection(new Point(0, text.length()));
            }
        }

        private class SelectText
        implements Runnable {
            private final Combo combo;

            SelectText(Combo combo) {
                this.combo = combo;
            }

            @Override
            public void run() {
                if (this.combo.isDisposed()) {
                    return;
                }
                String text = this.combo.getText();
                this.combo.setSelection(new Point(0, text.length()));
            }
        }
    }
}

