/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmBaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.EmbeddedIdMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddedId;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmEmbeddedIdMapping<X extends XmlEmbeddedId>
extends AbstractOrmBaseEmbeddedMapping<X>
implements EmbeddedIdMapping2_0,
OrmEmbeddedIdMapping {
    protected boolean derived;

    protected AbstractOrmEmbeddedIdMapping(OrmSpecifiedPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setMappedByRelationship(this.buildDerived());
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    protected void setMappedByRelationship(boolean derived) {
        boolean old = this.derived;
        this.derived = derived;
        this.firePropertyChanged("derived", old, derived);
    }

    protected boolean buildDerived() {
        return this.isJpa2_0Compatible() && this.buildDerived_();
    }

    protected boolean buildDerived_() {
        return this.getTypeMapping().attributeIsDerivedId(this.name);
    }

    @Override
    public String getKey() {
        return "embeddedId";
    }

    @Override
    public int getXmlSequence() {
        return 10;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmEmbeddedIdMapping(this);
    }

    @Override
    public void addXmlAttributeMappingTo(Attributes xmlAttributes) {
        xmlAttributes.getEmbeddedIds().add((Object)((XmlEmbeddedId)this.xmlAttributeMapping));
    }

    @Override
    public void removeXmlAttributeMappingFrom(Attributes xmlAttributes) {
        xmlAttributes.getEmbeddedIds().remove((Object)this.xmlAttributeMapping);
    }

    @Override
    protected Iterable<String> getEmbeddableOverridableAttributeMappingNames() {
        return this.derived ? EmptyIterable.instance() : super.getEmbeddableOverridableAttributeMappingNames();
    }

    @Override
    protected OrmAttributeOverrideContainer.ParentAdapter buildAttributeOverrideContainerParentAdapter() {
        return new AttributeOverrideContainerParentAdapter();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappedByRelationshipAndAttributeOverridesSpecified(messages, reporter);
    }

    @Override
    protected boolean validateTargetEmbeddable(List<IMessage> messages) {
        boolean continueValidating = super.validateTargetEmbeddable(messages);
        if (continueValidating) {
            if (this.getTargetEmbeddable().getJavaResourceType() != null) {
                this.validateTargetEmbeddableClass(messages);
            }
            this.validateNoRelationshipMappingsOnTargetEmbeddable(messages);
        }
        return true;
    }

    protected void validateTargetEmbeddableClass(List<IMessage> messages) {
        this.validateTargetEmbeddableImplementsEqualsAndHashcode(messages);
        this.validateTargetEmbeddableIsPublic(messages);
        this.validateTargetEmbeddableImplementsSerializable(messages);
        this.validateTargetEmbeddableImplementsNoArgConstructor(messages);
    }

    protected void validateNoRelationshipMappingsOnTargetEmbeddable(List<IMessage> messages) {
        TypeMapping targetEmbeddableTypeMapping = this.getTargetEmbeddable().getPersistentType().getMapping();
        if (targetEmbeddableTypeMapping.getAllAttributeMappings("manyToMany").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("manyToOne").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("oneToMany").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("oneToOne").iterator().hasNext()) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS));
        }
    }

    protected void validateTargetEmbeddableImplementsSerializable(List<IMessage> messages) {
        IJavaProject javaProject;
        String targetEmbeddableClassName = this.getTargetEmbeddable().getPersistentType().getName();
        if (!TypeTools.isSerializable((String)targetEmbeddableClassName, (IJavaProject)(javaProject = this.getJpaProject().getJavaProject()))) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE));
        }
    }

    protected void validateTargetEmbeddableIsPublic(List<IMessage> messages) {
        if (!this.getTargetEmbeddable().getJavaResourceType().isPublic()) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC));
        }
    }

    protected void validateTargetEmbeddableImplementsEqualsAndHashcode(List<IMessage> messages) {
        JavaResourceType resourceType = this.getTargetEmbeddable().getJavaResourceType();
        if (!resourceType.hasHashCodeMethod() || !resourceType.hasEqualsMethod()) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE));
        }
    }

    protected void validateTargetEmbeddableImplementsNoArgConstructor(List<IMessage> messages) {
        IJavaProject javaProject;
        String targetEmbeddableClassName = this.getTargetEmbeddable().getPersistentType().getName();
        if (!TypeTools.hasPublicZeroArgConstructor((String)targetEmbeddableClassName, (IJavaProject)(javaProject = this.getJpaProject().getJavaProject()))) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR));
        }
    }

    protected void validateMappedByRelationshipAndAttributeOverridesSpecified(List<IMessage> messages, IReporter reporter) {
        if (this.derived && this.attributeOverrideContainer.getSpecifiedOverridesSize() > 0) {
            messages.add(this.buildValidationMessage((JpaModel)this.attributeOverrideContainer, this.attributeOverrideContainer.getValidationTextRange(), JptJpaCoreValidationMessages.EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED));
        }
    }

    public class AttributeOverrideContainerParentAdapter
    extends AbstractOrmBaseEmbeddedMapping.AttributeOverrideContainerParentAdapter {
        public AttributeOverrideContainerParentAdapter() {
            super(AbstractOrmEmbeddedIdMapping.this);
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            return AbstractOrmEmbeddedIdMapping.this.isDerived() ? EmptyIterable.instance() : super.getAllOverridableNames();
        }

        @Override
        protected Iterable<String> getAllOverridableAttributeNames_(TypeMapping overriddenTypeMapping) {
            return IterableTools.filter(super.getAllOverridableAttributeNames_(overriddenTypeMapping), (Predicate)new OverrideContainer.ParentAdapter.AttributeIsOverridable(this));
        }
    }
}

