/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.core.internal.utility.LocalizedValidationMessage;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ValidationMessageLoader {
    private static final int PUBLIC_STATIC = 9;
    private static String[] LOCALE_SUFFIXES = ValidationMessageLoader.buildLocaleSuffixes();
    private static final int MAX_SUFFIXES = 4;
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private static final String _PROPERTIES_FILE_EXTENSION = ".properties";
    private static final int FIXED_MAX_SUFFIX_PORTION_LENGTH = ".properties".length() + 3;
    private static final MessagesProperties.Adapter MESSAGE_TEMPLATE_ADAPTER = new MessageTemplateAdapter();
    private static final MessagesProperties.Adapter MESSAGE_DESCRIPTION_ADAPTER = new MessageDescriptionAdapter();

    public static void load(Class<?> clazz, String messageBundleName, String descriptionBundleName, String markerType, PreferencesAdapter preferencesAdapter) {
        if (System.getSecurityManager() == null) {
            ValidationMessageLoader.load_(clazz, messageBundleName, descriptionBundleName, markerType, preferencesAdapter);
        } else {
            AccessController.doPrivileged(new LoadAction(clazz, messageBundleName, descriptionBundleName, markerType, preferencesAdapter));
        }
    }

    static void load_(Class<?> clazz, String messageBundleName, String descriptionBundleName, String markerType, PreferencesAdapter preferencesAdapter) {
        Field[] fields = clazz.getDeclaredFields();
        boolean classIsNotPublic = BitTools.flagIsOff((int)clazz.getModifiers(), (int)1);
        HashMap<String, FieldMessage> messages = new HashMap<String, FieldMessage>(BitTools.twice((int)fields.length));
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (BitTools.allFlagsAreSet((int)modifiers, (int)9) && BitTools.flagIsOff((int)modifiers, (int)16)) {
                if (classIsNotPublic) {
                    field.setAccessible(true);
                }
                String fieldName = field.getName();
                messages.put(fieldName, new FieldMessage(field, new SimpleValidationMessage(fieldName, markerType, preferencesAdapter)));
            }
            ++n2;
        }
        ArrayList<SimpleAssociation> pairs = new ArrayList<SimpleAssociation>(2);
        pairs.add(new SimpleAssociation((Object)messageBundleName, (Object)MESSAGE_TEMPLATE_ADAPTER));
        pairs.add(new SimpleAssociation((Object)descriptionBundleName, (Object)MESSAGE_DESCRIPTION_ADAPTER));
        ClassLoader classLoader = clazz.getClassLoader();
        for (SimpleAssociation simpleAssociation : pairs) {
            String bundleName = (String)simpleAssociation.getKey();
            MessagesProperties.Adapter adapter = (MessagesProperties.Adapter)simpleAssociation.getValue();
            String[] stringArray = ValidationMessageLoader.buildPropertiesFileNames(bundleName);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block22: {
                    InputStream stream;
                    String propertiesFileName = stringArray[n4];
                    InputStream inputStream = stream = classLoader == null ? ClassLoader.getSystemResourceAsStream(propertiesFileName) : classLoader.getResourceAsStream(propertiesFileName);
                    if (stream != null) {
                        MessagesProperties properties = new MessagesProperties(messages, propertiesFileName, adapter);
                        try {
                            try {
                                properties.load(stream);
                            }
                            catch (IOException ex) {
                                ValidationMessageLoader.logError(ex, "Error loading {0}", propertiesFileName);
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++n4;
            }
        }
        for (Map.Entry entry : messages.entrySet()) {
            String description;
            FieldMessage fieldMessage = (FieldMessage)entry.getValue();
            Field field = fieldMessage.field;
            SimpleValidationMessage message = fieldMessage.message;
            String template = message.template;
            if (template == null) {
                message.template = template = ValidationMessageLoader.bind("NLS missing message in bundle {0}: {1} ({2})", messageBundleName, entry.getKey(), clazz.getName());
                ValidationMessageLoader.logWarning(template, new Object[0]);
            }
            if ((description = message.description) == null) {
                message.description = description = ValidationMessageLoader.bind("NLS missing description in bundle {0}: {1} ({2})", descriptionBundleName, entry.getKey(), clazz.getName());
                ValidationMessageLoader.logWarning(description, new Object[0]);
            }
            try {
                field.set(null, message);
            }
            catch (Exception ex) {
                ValidationMessageLoader.logError(ex, "Error setting the message value for: {0}", field);
            }
        }
    }

    private static String[] buildPropertiesFileNames(String bundleName) {
        bundleName = bundleName.replace('.', '/');
        int len = LOCALE_SUFFIXES.length;
        String[] names = new String[len];
        int i = len;
        while (i-- > 0) {
            names[i] = String.valueOf(bundleName) + LOCALE_SUFFIXES[i];
        }
        return names;
    }

    private static String[] buildLocaleSuffixes() {
        return ValidationMessageLoader.buildLocaleSuffixes(Locale.getDefault());
    }

    private static String[] buildLocaleSuffixes(Locale locale) {
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        Object[] suffixes = new String[4];
        int i = 0;
        StringBuilder sb = new StringBuilder(languageLength + countryLength + variantLength + FIXED_MAX_SUFFIX_PORTION_LENGTH);
        sb.append('_').append(language).append('_').append(country).append('_').append(variant).append(_PROPERTIES_FILE_EXTENSION);
        int start = languageLength + countryLength + 2;
        if (variantLength != 0) {
            suffixes[i++] = sb.toString();
            sb.delete(start, start + variantLength + 1);
        } else {
            sb.deleteCharAt(start);
        }
        start = languageLength + 1;
        if (countryLength != 0) {
            suffixes[i++] = sb.toString();
            sb.delete(start, start + countryLength + 1);
        } else {
            sb.deleteCharAt(start);
        }
        if (languageLength != 0) {
            suffixes[i++] = sb.toString();
        }
        suffixes[i++] = _PROPERTIES_FILE_EXTENSION;
        return (String[])ArrayTools.subArray((Object[])suffixes, (int)0, (int)i);
    }

    private static String bind(String message, Object ... args) {
        return NLS.bind((String)message, (Object[])args);
    }

    static void logWarning(String message, Object ... args) {
        JptCommonCorePlugin.instance().log(2, message, args);
    }

    static void logError(Throwable throwable, String message, Object ... args) {
        JptCommonCorePlugin.instance().logError(throwable, message, args);
    }

    private static class FieldMessage {
        final Field field;
        final SimpleValidationMessage message;

        FieldMessage(Field field, SimpleValidationMessage message) {
            this.field = field;
            this.message = message;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.field.getName());
        }
    }

    private static class LoadAction
    implements PrivilegedAction<Object> {
        private final Class<?> clazz;
        private final String messageBundleName;
        private final String descriptionBundleName;
        private final String markerType;
        private final PreferencesAdapter preferencesAdapter;

        LoadAction(Class<?> clazz, String messageBundleName, String descriptionBundleName, String markerType, PreferencesAdapter preferencesAdapter) {
            this.clazz = clazz;
            this.messageBundleName = messageBundleName;
            this.markerType = markerType;
            this.preferencesAdapter = preferencesAdapter;
            this.descriptionBundleName = descriptionBundleName;
        }

        @Override
        public Object run() {
            ValidationMessageLoader.load_(this.clazz, this.messageBundleName, this.descriptionBundleName, this.markerType, this.preferencesAdapter);
            return null;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.clazz.getSimpleName());
        }
    }

    static class MessageDescriptionAdapter
    implements MessagesProperties.Adapter {
        MessageDescriptionAdapter() {
        }

        @Override
        public void put(SimpleValidationMessage message, Object value) {
            if (message.description == null) {
                message.description = new String(value.toString().toCharArray());
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    static class MessageTemplateAdapter
    implements MessagesProperties.Adapter {
        MessageTemplateAdapter() {
        }

        @Override
        public void put(SimpleValidationMessage message, Object value) {
            if (message.template == null) {
                message.template = new String(value.toString().toCharArray());
            }
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    private static class MessagesProperties
    extends Properties {
        private final Map<String, FieldMessage> fieldMessages;
        private final String propertiesFileName;
        private final Adapter adapter;
        private static final long serialVersionUID = 1L;

        MessagesProperties(Map<String, FieldMessage> fieldMessages, String propertiesFileName, Adapter adapter) {
            this.fieldMessages = fieldMessages;
            this.propertiesFileName = propertiesFileName;
            this.adapter = adapter;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            FieldMessage fieldMessage = this.fieldMessages.get(key);
            if (fieldMessage != null) {
                this.adapter.put(fieldMessage.message, value);
            } else {
                ValidationMessageLoader.logWarning("NLS unused message in bundle file {0}: {1}", this.propertiesFileName, key);
            }
            return null;
        }

        static interface Adapter {
            public void put(SimpleValidationMessage var1, Object var2);
        }
    }

    public static class PluginPreferencesAdapter
    implements PreferencesAdapter {
        private final JptPlugin plugin;

        public PluginPreferencesAdapter(JptPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public int getSeverity(IProject project, String messageID, int defaultSeverity) {
            return this.plugin.getValidationMessageSeverity(project, messageID, defaultSeverity);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.plugin);
        }
    }

    public static interface PreferencesAdapter {
        public int getSeverity(IProject var1, String var2, int var3);
    }

    private static class SimpleValidationMessage
    implements ValidationMessage {
        private final String id;
        private final String markerType;
        private final PreferencesAdapter preferencesAdapter;
        String template;
        String description;
        private int defaultSeverity = 1;

        SimpleValidationMessage(String id, String markerType, PreferencesAdapter preferencesAdapter) {
            this.id = id;
            this.markerType = markerType;
            this.preferencesAdapter = preferencesAdapter;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getDefaultSeverity() {
            return this.defaultSeverity;
        }

        @Override
        public void setDefaultSeverity(int severity) {
            this.defaultSeverity = severity;
        }

        @Override
        public IMessage buildValidationMessage(IResource target, TextRange textRange, Object ... args) {
            int severity = this.preferencesAdapter.getSeverity(target.getProject(), this.id, this.defaultSeverity);
            String localizedMessage = this.bind(args);
            LocalizedValidationMessage message = new LocalizedValidationMessage(severity, this.id, target, localizedMessage);
            message.setMarkerId(this.markerType);
            if (textRange == null) {
                textRange = EmptyTextRange.instance();
                ValidationMessageLoader.logError(new NullPointerException(), "Null text range for message ID: {0}", this.id);
            }
            int lineNumber = textRange.getLineNumber();
            message.setLineNo(lineNumber);
            if (lineNumber == 0) {
                message.setAttribute("location", " ");
            }
            message.setOffset(textRange.getOffset());
            message.setLength(textRange.getLength());
            return message;
        }

        private String bind(Object ... args) {
            return NLS.bind((String)this.template, (Object[])args);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.id);
        }
    }
}

